/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.event;

import org.springframework.context.ApplicationEvent;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.Assert;

public final class OAuth2AuthorizedClientRefreshedEvent
extends ApplicationEvent {
    private static final long serialVersionUID = -2178028089321556476L;
    private final OAuth2AuthorizedClient authorizedClient;

    public OAuth2AuthorizedClientRefreshedEvent(OAuth2AccessTokenResponse accessTokenResponse, OAuth2AuthorizedClient authorizedClient) {
        super((Object)accessTokenResponse);
        Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
        this.authorizedClient = authorizedClient;
    }

    public OAuth2AccessTokenResponse getAccessTokenResponse() {
        return (OAuth2AccessTokenResponse)this.getSource();
    }

    public OAuth2AuthorizedClient getAuthorizedClient() {
        return this.authorizedClient;
    }
}

