/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class JwtTypeValidator
implements OAuth2TokenValidator<Jwt> {
    private final Collection<String> validTypes;
    private boolean allowEmpty;

    public JwtTypeValidator(Collection<String> validTypes) {
        Assert.notEmpty(validTypes, (String)"validTypes cannot be empty");
        this.validTypes = new ArrayList<String>(validTypes);
    }

    public JwtTypeValidator(String ... validTypes) {
        this(List.of(validTypes));
    }

    public static JwtTypeValidator jwt() {
        JwtTypeValidator validator = new JwtTypeValidator(List.of("JWT"));
        validator.setAllowEmpty(true);
        return validator;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public OAuth2TokenValidatorResult validate(Jwt token) {
        String typ = (String)token.getHeaders().get("typ");
        if (this.allowEmpty && !StringUtils.hasText((String)typ)) {
            return OAuth2TokenValidatorResult.success();
        }
        if (this.validTypes.contains(typ)) {
            return OAuth2TokenValidatorResult.success();
        }
        return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_token", "the given typ value needs to be one of " + String.valueOf(this.validTypes), "https://datatracker.ietf.org/doc/html/rfc7515#section-4.1.9")});
    }
}

