/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.ui;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.authentication.ui.HtmlTemplates;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class DefaultLogoutPageGeneratingFilter
extends OncePerRequestFilter {
    private RequestMatcher matcher = PathPatternRequestMatcher.pathPattern(HttpMethod.GET, "/logout");
    private Function<HttpServletRequest, Map<String, String>> resolveHiddenInputs = request -> Collections.emptyMap();
    private static final String LOGOUT_PAGE_TEMPLATE = "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">\n    <meta name=\"description\" content=\"\">\n    <meta name=\"author\" content=\"\">\n    <title>Confirm Log Out?</title>\n    <link href=\"{{contextPath}}/default-ui.css\" rel=\"stylesheet\" />\n  </head>\n  <body>\n    <div class=\"content\">\n      <form class=\"logout-form\" method=\"post\" action=\"{{contextPath}}/logout\">\n        <h2>Are you sure you want to log out?</h2>\n{{hiddenInputs}}\n        <button class=\"primary\" type=\"submit\">Log Out</button>\n      </form>\n    </div>\n  </body>\n</html>";
    private static final String HIDDEN_HTML_INPUT_TEMPLATE = "<input name=\"{{name}}\" type=\"hidden\" value=\"{{value}}\" />\n";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.matcher.matches(request)) {
            this.renderLogout(request, response);
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Did not render default logout page since request did not match [%s]", (Object)this.matcher));
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void renderLogout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String renderedPage = HtmlTemplates.fromTemplate(LOGOUT_PAGE_TEMPLATE).withValue("contextPath", request.getContextPath()).withRawHtml("hiddenInputs", this.renderHiddenInputs(request).indent(8)).render();
        response.setContentType("text/html;charset=UTF-8");
        response.getWriter().write(renderedPage);
    }

    public void setResolveHiddenInputs(Function<HttpServletRequest, Map<String, String>> resolveHiddenInputs) {
        Assert.notNull(resolveHiddenInputs, (String)"resolveHiddenInputs cannot be null");
        this.resolveHiddenInputs = resolveHiddenInputs;
    }

    private String renderHiddenInputs(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> input : this.resolveHiddenInputs.apply(request).entrySet()) {
            String inputElement = HtmlTemplates.fromTemplate(HIDDEN_HTML_INPUT_TEMPLATE).withValue("name", input.getKey()).withValue("value", input.getValue()).render();
            sb.append(inputElement);
        }
        return sb.toString();
    }
}

