/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.www;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.core.log.LogMessage;
import org.springframework.lang.Contract;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.NullRememberMeServices;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.www.BasicAuthenticationConverter;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class BasicAuthenticationFilter
extends OncePerRequestFilter {
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private @Nullable AuthenticationEntryPoint authenticationEntryPoint;
    private AuthenticationManager authenticationManager;
    private RememberMeServices rememberMeServices = new NullRememberMeServices();
    private boolean ignoreFailure = false;
    private String credentialsCharset = "UTF-8";
    private AuthenticationConverter authenticationConverter = new BasicAuthenticationConverter();
    private SecurityContextRepository securityContextRepository = new RequestAttributeSecurityContextRepository();
    private boolean mfaEnabled;

    public BasicAuthenticationFilter(AuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
        this.ignoreFailure = true;
    }

    public BasicAuthenticationFilter(AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.notNull((Object)authenticationEntryPoint, (String)"authenticationEntryPoint cannot be null");
        this.authenticationManager = authenticationManager;
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setSecurityContextRepository(SecurityContextRepository securityContextRepository) {
        Assert.notNull((Object)securityContextRepository, (String)"securityContextRepository cannot be null");
        this.securityContextRepository = securityContextRepository;
    }

    public void setMfaEnabled(boolean mfaEnabled) {
        this.mfaEnabled = mfaEnabled;
    }

    public void setAuthenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager is required");
        if (!this.isIgnoreFailure()) {
            Assert.notNull((Object)this.authenticationEntryPoint, (String)"An AuthenticationEntryPoint is required");
        }
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Authentication authRequest = this.authenticationConverter.convert(request);
            if (authRequest == null) {
                this.logger.trace((Object)"Did not process authentication request since failed to find username and password in Basic Authorization header");
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            String username = authRequest.getName();
            this.logger.trace((Object)LogMessage.format((String)"Found username '%s' in Basic Authorization header", (Object)username));
            if (this.authenticationIsRequired(username)) {
                Authentication authResult = this.authenticationManager.authenticate(authRequest);
                Authentication current = this.securityContextHolderStrategy.getContext().getAuthentication();
                if (this.shouldPerformMfa(current, authResult)) {
                    authResult = authResult.toBuilder().authorities(a -> {
                        Set newAuthorities = a.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toUnmodifiableSet());
                        for (GrantedAuthority currentAuthority : current.getAuthorities()) {
                            if (newAuthorities.contains(currentAuthority.getAuthority())) continue;
                            a.add(currentAuthority);
                        }
                    }).build();
                }
                SecurityContext context = this.securityContextHolderStrategy.createEmptyContext();
                context.setAuthentication(authResult);
                this.securityContextHolderStrategy.setContext(context);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)LogMessage.format((String)"Set SecurityContextHolder to %s", (Object)authResult));
                }
                this.rememberMeServices.loginSuccess(request, response, authResult);
                this.securityContextRepository.saveContext(context, request, response);
                this.onSuccessfulAuthentication(request, response, authResult);
            }
        }
        catch (AuthenticationException ex) {
            this.securityContextHolderStrategy.clearContext();
            this.logger.debug((Object)"Failed to process authentication request", (Throwable)ex);
            this.rememberMeServices.loginFail(request, response);
            this.onUnsuccessfulAuthentication(request, response, ex);
            if (this.ignoreFailure || this.authenticationEntryPoint == null) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                this.authenticationEntryPoint.commence(request, response, ex);
            }
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Contract(value="null, _ -> false")
    private boolean shouldPerformMfa(@Nullable Authentication current, Authentication authenticationResult) {
        if (!this.mfaEnabled) {
            return false;
        }
        if (current == null || !current.isAuthenticated()) {
            return false;
        }
        if (!BasicAuthenticationFilter.declaresToBuilder(authenticationResult)) {
            return false;
        }
        return current.getName().equals(authenticationResult.getName());
    }

    private static boolean declaresToBuilder(Authentication authentication) {
        for (Method method : authentication.getClass().getDeclaredMethods()) {
            if (!method.getName().equals("toBuilder") || method.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean authenticationIsRequired(String username) {
        Authentication existingAuth = this.securityContextHolderStrategy.getContext().getAuthentication();
        if (existingAuth == null || !existingAuth.getName().equals(username) || !existingAuth.isAuthenticated()) {
            return true;
        }
        return existingAuth instanceof AnonymousAuthenticationToken;
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
    }

    protected @Nullable AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    protected AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    protected boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        AuthenticationConverter authenticationConverter = this.authenticationConverter;
        if (authenticationConverter instanceof BasicAuthenticationConverter) {
            BasicAuthenticationConverter basicAuthenticationConverter = (BasicAuthenticationConverter)authenticationConverter;
            basicAuthenticationConverter.setAuthenticationDetailsSource(authenticationDetailsSource);
        }
    }

    public void setRememberMeServices(RememberMeServices rememberMeServices) {
        Assert.notNull((Object)rememberMeServices, (String)"rememberMeServices cannot be null");
        this.rememberMeServices = rememberMeServices;
    }

    public void setCredentialsCharset(String credentialsCharset) {
        Assert.hasText((String)credentialsCharset, (String)"credentialsCharset cannot be null or empty");
        this.credentialsCharset = credentialsCharset;
        AuthenticationConverter authenticationConverter = this.authenticationConverter;
        if (authenticationConverter instanceof BasicAuthenticationConverter) {
            BasicAuthenticationConverter basicAuthenticationConverter = (BasicAuthenticationConverter)authenticationConverter;
            basicAuthenticationConverter.setCredentialsCharset(Charset.forName(credentialsCharset));
        }
    }

    protected String getCredentialsCharset(HttpServletRequest httpRequest) {
        return this.credentialsCharset;
    }
}

