/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.resilience.retry;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.concurrent.Future;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.retry.RetryException;
import org.springframework.core.retry.RetryListener;
import org.springframework.core.retry.RetryPolicy;
import org.springframework.core.retry.RetryState;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.core.retry.Retryable;
import org.springframework.resilience.retry.MethodRetryEvent;
import org.springframework.resilience.retry.MethodRetrySpec;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public abstract class AbstractRetryInterceptor
implements MethodInterceptor,
ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog(AbstractRetryInterceptor.class);
    private static final boolean REACTIVE_STREAMS_PRESENT = ClassUtils.isPresent((String)"org.reactivestreams.Publisher", (ClassLoader)AbstractRetryInterceptor.class.getClassLoader());
    private final @Nullable ReactiveAdapterRegistry reactiveAdapterRegistry = REACTIVE_STREAMS_PRESENT ? ReactiveAdapterRegistry.getSharedInstance() : null;
    private @Nullable ApplicationEventPublisher applicationEventPublisher;

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public @Nullable Object invoke(final MethodInvocation invocation) throws Throwable {
        ReactiveAdapter adapter;
        Object target;
        Method method = invocation.getMethod();
        MethodRetrySpec spec = this.getRetrySpec(method, (target = invocation.getThis()) != null ? target.getClass() : method.getDeclaringClass());
        if (spec == null) {
            return invocation.proceed();
        }
        if (this.reactiveAdapterRegistry != null && !Future.class.isAssignableFrom(method.getReturnType()) && (adapter = this.reactiveAdapterRegistry.getAdapter(method.getReturnType())) != null) {
            Object result = invocation.proceed();
            if (result == null) {
                return null;
            }
            return new ReactorDelegate().adaptReactiveResult(invocation, result, adapter, spec);
        }
        RetryPolicy retryPolicy = RetryPolicy.builder().includes(spec.includes()).excludes(spec.excludes()).predicate(spec.predicate().forMethod(method)).maxRetries(spec.maxRetries()).timeout(spec.timeout()).delay(spec.delay()).jitter(spec.jitter()).multiplier(spec.multiplier()).maxDelay(spec.maxDelay()).build();
        RetryTemplate retryTemplate = new RetryTemplate(retryPolicy);
        retryTemplate.setRetryListener(new RetryListener(){
            final /* synthetic */ AbstractRetryInterceptor this$0;
            {
                this.this$0 = this$0;
            }

            public void onRetryableExecution(RetryPolicy retryPolicy, Retryable<?> retryable, RetryState retryState) {
                if (!retryState.isSuccessful()) {
                    this.this$0.onEvent(new MethodRetryEvent(invocation, retryState.getLastException(), false));
                }
            }
        });
        final String methodName = ClassUtils.getQualifiedMethodName((Method)method, target != null ? target.getClass() : null);
        try {
            return retryTemplate.execute((Retryable)new Retryable<Object>(){
                final /* synthetic */ AbstractRetryInterceptor this$0;
                {
                    this.this$0 = this$0;
                }

                public @Nullable Object execute() throws Throwable {
                    Object object;
                    if (invocation instanceof ProxyMethodInvocation) {
                        ProxyMethodInvocation pmi = (ProxyMethodInvocation)invocation;
                        object = pmi.invocableClone().proceed();
                    } else {
                        object = invocation.proceed();
                    }
                    return object;
                }

                public String getName() {
                    return methodName;
                }
            });
        }
        catch (RetryException ex) {
            this.onEvent(new MethodRetryEvent(invocation, ex, true));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Retryable operation '%s' failed".formatted(methodName), (Throwable)ex);
            }
            throw ex.getCause();
        }
    }

    private void onEvent(MethodRetryEvent event) {
        logger.trace((Object)event, event.getFailure());
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent(event);
        }
    }

    protected abstract @Nullable MethodRetrySpec getRetrySpec(Method var1, Class<?> var2);

    private class ReactorDelegate {
        private ReactorDelegate() {
        }

        public Object adaptReactiveResult(MethodInvocation invocation, Object result, ReactiveAdapter adapter, MethodRetrySpec spec) {
            boolean timeoutIsPositive;
            Publisher publisher = adapter.toPublisher(result);
            RetryBackoffSpec retry = Retry.backoff((long)spec.maxRetries(), (Duration)spec.delay()).jitter(ReactorDelegate.calculateJitterFactor(spec)).multiplier(spec.multiplier()).maxBackoff(spec.maxDelay()).filter(spec.combinedPredicate().forMethod(invocation.getMethod()));
            Duration timeout = spec.timeout();
            boolean bl = timeoutIsPositive = !timeout.isNegative() && !timeout.isZero();
            if (adapter.isMultiValue()) {
                Flux flux = Flux.from((Publisher)publisher).doOnError(ex -> AbstractRetryInterceptor.this.onEvent(new MethodRetryEvent(invocation, (Throwable)ex, false))).retryWhen((Retry)retry);
                if (timeoutIsPositive) {
                    flux = flux.timeout(timeout);
                }
                flux = flux.doOnError(ex -> AbstractRetryInterceptor.this.onEvent(new MethodRetryEvent(invocation, (Throwable)ex, true)));
                publisher = flux;
            } else {
                Mono mono = Mono.from((Publisher)publisher).doOnError(ex -> AbstractRetryInterceptor.this.onEvent(new MethodRetryEvent(invocation, (Throwable)ex, false))).retryWhen((Retry)retry);
                if (timeoutIsPositive) {
                    mono = mono.timeout(timeout);
                }
                mono = mono.doOnError(ex -> AbstractRetryInterceptor.this.onEvent(new MethodRetryEvent(invocation, (Throwable)ex, true)));
                publisher = mono;
            }
            return adapter.fromPublisher(publisher);
        }

        private static double calculateJitterFactor(MethodRetrySpec spec) {
            return spec.delay().isZero() ? 0.0 : Math.max(0.0, Math.min(1.0, (double)spec.jitter().toNanos() / (double)spec.delay().toNanos()));
        }
    }
}

