/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMessage;
import org.springframework.http.MediaType;
import org.springframework.util.FileCopyUtils;

abstract class RestClientUtils {
    RestClientUtils() {
    }

    public static byte[] getBody(HttpInputMessage message) {
        try {
            return FileCopyUtils.copyToByteArray((InputStream)message.getBody());
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    public static @Nullable Charset getCharset(HttpMessage response) {
        HttpHeaders headers = response.getHeaders();
        MediaType contentType = headers.getContentType();
        return contentType != null ? contentType.getCharset() : null;
    }
}

