/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeanUtils;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.HandlerResultHandlerSupport;
import org.springframework.web.reactive.result.view.Fragment;
import org.springframework.web.reactive.result.view.FragmentsRendering;
import org.springframework.web.reactive.result.view.Rendering;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ViewResolutionResultHandler
extends HandlerResultHandlerSupport
implements HandlerResultHandler,
Ordered {
    private static final Object NO_VALUE = new Object();
    private static final Mono<Object> NO_VALUE_MONO = Mono.just((Object)NO_VALUE);
    private final List<ViewResolver> viewResolvers = new ArrayList<ViewResolver>(4);
    private final List<View> defaultViews = new ArrayList<View>(4);
    private final SseStreamHandler sseHandler = new SseStreamHandler();

    public ViewResolutionResultHandler(List<ViewResolver> viewResolvers, RequestedContentTypeResolver contentTypeResolver) {
        this(viewResolvers, contentTypeResolver, ReactiveAdapterRegistry.getSharedInstance());
    }

    public ViewResolutionResultHandler(List<ViewResolver> viewResolvers, RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry registry) {
        super(contentTypeResolver, registry);
        this.viewResolvers.addAll(viewResolvers);
        AnnotationAwareOrderComparator.sort(this.viewResolvers);
    }

    public List<ViewResolver> getViewResolvers() {
        return Collections.unmodifiableList(this.viewResolvers);
    }

    public void setDefaultViews(@Nullable List<View> defaultViews) {
        this.defaultViews.clear();
        if (defaultViews != null) {
            this.defaultViews.addAll(defaultViews);
        }
    }

    public List<View> getDefaultViews() {
        return this.defaultViews;
    }

    @Override
    public boolean supports(HandlerResult result) {
        if (this.hasModelAnnotation(result.getReturnTypeSource())) {
            return true;
        }
        ResolvableType returnType = result.getReturnType();
        Class type = returnType.toClass();
        ReactiveAdapter adapter = this.getAdapter(result);
        if (adapter != null) {
            if (adapter.isNoValue()) {
                return true;
            }
            type = returnType.getGeneric(new int[0]).toClass();
            returnType = returnType.getNested(2);
            if (adapter.isMultiValue()) {
                return Fragment.class.isAssignableFrom(type) || ViewResolutionResultHandler.isSseFragmentStream(returnType);
            }
        }
        return CharSequence.class.isAssignableFrom(type) || Rendering.class.isAssignableFrom(type) || FragmentsRendering.class.isAssignableFrom(type) || Model.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || View.class.isAssignableFrom(type) || ViewResolutionResultHandler.isFragmentCollection(returnType.getNested(2)) || !BeanUtils.isSimpleProperty((Class)type);
    }

    private boolean hasModelAnnotation(MethodParameter parameter) {
        return parameter.hasMethodAnnotation(ModelAttribute.class);
    }

    private static boolean isFragmentCollection(ResolvableType returnType) {
        return Collection.class.isAssignableFrom(returnType.resolve(Object.class)) && Fragment.class.equals((Object)returnType.getNested(2).resolve());
    }

    private static boolean isSseFragmentStream(ResolvableType returnType) {
        return ServerSentEvent.class.equals((Object)returnType.resolve()) && Fragment.class.equals((Object)returnType.getNested(2).resolve());
    }

    @Override
    public Mono<Void> handleResult(ServerWebExchange exchange2, HandlerResult result) {
        ResolvableType valueType;
        Mono valueMono;
        ReactiveAdapter adapter = this.getAdapter(result);
        BindingContext bindingContext = result.getBindingContext();
        Locale locale = LocaleContextHolder.getLocale((LocaleContext)exchange2.getLocaleContext());
        if (adapter != null) {
            if (adapter.isMultiValue()) {
                if (ViewResolutionResultHandler.isSseFragmentStream(result.getReturnType().getNested(2))) {
                    return this.handleSseFragmentStream(exchange2, result, adapter, locale, bindingContext);
                }
                valueMono = result.getReturnValue() != null ? Mono.just((Object)FragmentsRendering.fragmentsPublisher(adapter.toPublisher(result.getReturnValue())).build()) : Mono.empty();
                valueType = ResolvableType.forClass(FragmentsRendering.class);
            } else {
                valueMono = result.getReturnValue() != null ? Mono.from((Publisher)adapter.toPublisher(result.getReturnValue())) : Mono.empty();
                valueType = adapter.isNoValue() ? ResolvableType.forClass(Void.class) : result.getReturnType().getGeneric(new int[0]);
            }
        } else {
            valueMono = Mono.justOrEmpty((Object)result.getReturnValue());
            valueType = result.getReturnType();
        }
        return valueMono.switchIfEmpty(exchange2.isNotModified() ? Mono.empty() : NO_VALUE_MONO).flatMap(returnValue -> {
            Mono<List<View>> viewsMono;
            Model model = result.getModel();
            MethodParameter parameter = result.getReturnTypeSource();
            Class<Object> clazz = valueType.toClass();
            if (clazz == Object.class) {
                clazz = returnValue.getClass();
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                returnValue = FragmentsRendering.fragments((Collection)returnValue).build();
                clazz = FragmentsRendering.class;
            }
            if (returnValue == NO_VALUE || ClassUtils.isVoidType(clazz)) {
                viewsMono = this.resolveViews(this.getDefaultViewName(exchange2), locale);
            } else if (CharSequence.class.isAssignableFrom(clazz) && !this.hasModelAnnotation(parameter)) {
                viewsMono = this.resolveViews(returnValue.toString(), locale);
            } else if (Rendering.class.isAssignableFrom(clazz)) {
                Mono<List<View>> mono;
                Rendering render = (Rendering)returnValue;
                HttpStatusCode status = render.status();
                if (status != null) {
                    exchange2.getResponse().setStatusCode(status);
                }
                exchange2.getResponse().getHeaders().putAll((Map)render.headers());
                model.addAllAttributes(render.modelAttributes());
                Object view = render.view();
                if (view == null) {
                    view = this.getDefaultViewName(exchange2);
                }
                if (view instanceof String) {
                    String viewName = (String)view;
                    mono = this.resolveViews(viewName, locale);
                } else {
                    mono = Mono.just(Collections.singletonList((View)view));
                }
                viewsMono = mono;
            } else {
                if (FragmentsRendering.class.isAssignableFrom(clazz)) {
                    SseStreamHandler streamHandler;
                    ServerHttpResponse response = exchange2.getResponse();
                    FragmentsRendering render = (FragmentsRendering)returnValue;
                    HttpStatusCode status = render.status();
                    if (status != null) {
                        response.setStatusCode(status);
                    }
                    response.getHeaders().putAll((Map)render.headers());
                    bindingContext.updateModel(exchange2);
                    SseStreamHandler sseStreamHandler = streamHandler = this.sseHandler.supports(exchange2.getRequest()) ? this.sseHandler : null;
                    if (streamHandler != null) {
                        streamHandler.updateResponse(exchange2);
                    }
                    Flux renderFlux = render.fragments().concatMap(fragment -> this.renderFragment((Fragment)fragment, null, streamHandler, locale, bindingContext, exchange2)).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
                    return response.writeAndFlushWith((Publisher)renderFlux);
                }
                if (Model.class.isAssignableFrom(clazz)) {
                    model.addAllAttributes(((Model)returnValue).asMap());
                    viewsMono = this.resolveViews(this.getDefaultViewName(exchange2), locale);
                } else if (Map.class.isAssignableFrom(clazz) && !this.hasModelAnnotation(parameter)) {
                    model.addAllAttributes((Map)returnValue);
                    viewsMono = this.resolveViews(this.getDefaultViewName(exchange2), locale);
                } else if (View.class.isAssignableFrom(clazz)) {
                    viewsMono = Mono.just(Collections.singletonList((View)returnValue));
                } else {
                    String name = this.getNameForReturnValue(parameter);
                    model.addAttribute(name, returnValue);
                    viewsMono = this.resolveViews(this.getDefaultViewName(exchange2), locale);
                }
            }
            bindingContext.updateModel(exchange2);
            return viewsMono.flatMap(views -> this.render((List<View>)views, model.asMap(), null, bindingContext, exchange2));
        });
    }

    private String getDefaultViewName(ServerWebExchange exchange2) {
        String path = exchange2.getRequest().getPath().pathWithinApplication().value();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return StringUtils.stripFilenameExtension((String)path);
    }

    private Mono<List<View>> resolveViews(String viewName, Locale locale) {
        return Flux.fromIterable(this.getViewResolvers()).concatMap(resolver -> resolver.resolveViewName(viewName, locale)).collectList().map(views -> {
            if (views.isEmpty()) {
                throw new IllegalStateException("Could not resolve view with name '" + viewName + "'.");
            }
            views.addAll(this.getDefaultViews());
            return views;
        });
    }

    private Mono<Void> handleSseFragmentStream(ServerWebExchange exchange2, HandlerResult result, ReactiveAdapter adapter, Locale locale, BindingContext bindingContext) {
        this.sseHandler.updateResponse(exchange2);
        Flux eventFlux = Flux.from((Publisher)adapter.toPublisher(result.getReturnValue()));
        Flux dataBufferFlux = eventFlux.concatMap(event -> this.renderFragment((Fragment)event.data(), event, this.sseHandler, locale, bindingContext, exchange2)).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
        return exchange2.getResponse().writeAndFlushWith((Publisher)dataBufferFlux);
    }

    private Mono<Flux<DataBuffer>> renderFragment(@Nullable Fragment fragment, @Nullable Object streamingHints, @Nullable StreamHandler streamHandler, Locale locale, BindingContext bindingContext, ServerWebExchange exchange2) {
        if (fragment == null) {
            return Mono.empty();
        }
        fragment.mergeAttributes(bindingContext.getModel());
        BodySavingResponse response = new BodySavingResponse(exchange2.getResponse());
        ServerWebExchange mutatedExchange = exchange2.mutate().response((ServerHttpResponse)response).build();
        Mono<List<View>> selectedViews = fragment.isResolved() ? Mono.just(List.of(fragment.view())) : this.resolveViews(fragment.viewName() != null ? fragment.viewName() : this.getDefaultViewName(exchange2), locale);
        Map<String, Object> model = fragment.model();
        if (streamHandler != null) {
            return selectedViews.flatMap(views -> this.render((List<View>)views, model, MediaType.TEXT_HTML, bindingContext, mutatedExchange)).then(Mono.fromSupplier(() -> streamHandler.format(response.getBodyFlux(), fragment, streamingHints, exchange2)));
        }
        return selectedViews.flatMap(views -> this.render((List<View>)views, model, null, bindingContext, mutatedExchange)).then(Mono.fromSupplier(response::getBodyFlux));
    }

    private String getNameForReturnValue(MethodParameter returnType) {
        return Optional.ofNullable((ModelAttribute)returnType.getMethodAnnotation(ModelAttribute.class)).filter(ann -> StringUtils.hasText((String)ann.value())).map(ModelAttribute::value).orElseGet(() -> Conventions.getVariableNameForParameter((MethodParameter)returnType));
    }

    private Mono<? extends Void> render(List<View> views, Map<String, Object> model, @Nullable MediaType bestMediaType, BindingContext bindingContext, ServerWebExchange exchange2) {
        for (View view : views) {
            if (!view.isRedirectView()) continue;
            return this.renderWith(view, model, null, exchange2, bindingContext);
        }
        List<MediaType> mediaTypes = this.getMediaTypes(views);
        if (bestMediaType == null) {
            try {
                bestMediaType = this.selectMediaType(exchange2, () -> mediaTypes);
            }
            catch (NotAcceptableStatusException ex) {
                HttpStatusCode statusCode = exchange2.getResponse().getStatusCode();
                if (statusCode != null && statusCode.isError()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring error response content (if any). " + ex.getReason()));
                    }
                    return Mono.empty();
                }
                throw ex;
            }
        }
        if (bestMediaType != null) {
            for (View view : views) {
                for (MediaType mediaType : view.getSupportedMediaTypes()) {
                    if (!mediaType.isCompatibleWith(bestMediaType)) continue;
                    return this.renderWith(view, model, mediaType, exchange2, bindingContext);
                }
            }
        }
        throw new NotAcceptableStatusException(mediaTypes);
    }

    private Mono<? extends Void> renderWith(View view, Map<String, Object> model, @Nullable MediaType mediaType, ServerWebExchange exchange2, BindingContext bindingContext) {
        exchange2.getAttributes().put(View.BINDING_CONTEXT_ATTRIBUTE, bindingContext);
        return view.render(model, mediaType, exchange2).doOnTerminate(() -> exchange2.getAttributes().remove(View.BINDING_CONTEXT_ATTRIBUTE));
    }

    private List<MediaType> getMediaTypes(List<View> views) {
        return views.stream().flatMap(view -> view.getSupportedMediaTypes().stream()).toList();
    }

    private static class SseStreamHandler
    implements StreamHandler {
        private SseStreamHandler() {
        }

        @Override
        public boolean supports(ServerHttpRequest request) {
            String header = request.getHeaders().getFirst("Accept");
            return header != null && header.contains("text/event-stream");
        }

        @Override
        public void updateResponse(ServerWebExchange exchange2) {
            MediaType mediaType = MediaType.TEXT_EVENT_STREAM;
            Charset charset = this.getCharset(exchange2.getRequest());
            mediaType = charset != null ? new MediaType(mediaType, charset) : mediaType;
            exchange2.getResponse().getHeaders().setContentType(mediaType);
        }

        @Nullable
        private Charset getCharset(ServerHttpRequest request) {
            for (MediaType mediaType : request.getHeaders().getAccept()) {
                if (!mediaType.isCompatibleWith(MediaType.TEXT_EVENT_STREAM)) continue;
                if (mediaType.getCharset() == null) break;
                return mediaType.getCharset();
            }
            return null;
        }

        @Override
        public Flux<DataBuffer> format(Flux<DataBuffer> fragmentFlux, Fragment fragment, @Nullable Object hints, ServerWebExchange exchange2) {
            MediaType mediaType = exchange2.getResponse().getHeaders().getContentType();
            Charset charset = mediaType != null && mediaType.getCharset() != null ? mediaType.getCharset() : StandardCharsets.UTF_8;
            Assert.state((hints == null || hints instanceof ServerSentEvent ? 1 : 0) != 0, (String)"Expected ServerSentEvent");
            DataBufferFactory bufferFactory = exchange2.getResponse().bufferFactory();
            ServerSentEvent sse = (ServerSentEvent)hints;
            String eventText = sse != null ? sse.format() : (String)(fragment.viewName() != null ? "event:" + fragment.viewName() + "\n" : "") + "data:";
            DataBuffer prefix = this.encodeText(eventText.toString(), charset, bufferFactory);
            DataBuffer suffix = this.encodeText("\n\n", charset, bufferFactory);
            Mono content = DataBufferUtils.join(fragmentFlux).map(buffer -> {
                String text;
                try {
                    text = buffer.toString(charset);
                }
                finally {
                    DataBufferUtils.release((DataBuffer)buffer);
                }
                text = text.replace("\n", "\ndata:");
                return bufferFactory.wrap(text.getBytes(charset));
            });
            return Flux.concat((Publisher[])new Publisher[]{Flux.just((Object)prefix), content, Flux.just((Object)suffix)});
        }

        private DataBuffer encodeText(String text, Charset charset, DataBufferFactory bufferFactory) {
            byte[] bytes = text.getBytes(charset);
            return bufferFactory.wrap(bytes);
        }
    }

    private static class BodySavingResponse
    extends ServerHttpResponseDecorator {
        @Nullable
        private Flux<DataBuffer> bodyFlux;
        @Nullable
        private HttpHeaders headers;

        BodySavingResponse(ServerHttpResponse delegate) {
            super(delegate);
        }

        public HttpHeaders getHeaders() {
            if (!super.getHeaders().containsKey((Object)"Content-Type")) {
                return super.getHeaders();
            }
            if (this.headers == null) {
                this.headers = new HttpHeaders();
                this.headers.putAll((Map)super.getHeaders());
            }
            return this.headers;
        }

        public Flux<DataBuffer> getBodyFlux() {
            Assert.state((this.bodyFlux != null ? 1 : 0) != 0, (String)"Body not set");
            return this.bodyFlux;
        }

        public Mono<Void> writeWith(Publisher<? extends DataBuffer> body2) {
            this.bodyFlux = Flux.from(body2);
            return Mono.empty();
        }

        public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body2) {
            this.bodyFlux = Flux.from(body2).flatMap(Flux::from);
            return Mono.empty();
        }
    }

    private static interface StreamHandler {
        public boolean supports(ServerHttpRequest var1);

        public void updateResponse(ServerWebExchange var1);

        public Flux<DataBuffer> format(Flux<DataBuffer> var1, Fragment var2, @Nullable Object var3, ServerWebExchange var4);
    }
}

