/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import org.springframework.jms.connection.SingleConnectionFactory;

public class SingleConnectionFactory102
extends SingleConnectionFactory {
    private boolean pubSubDomain = false;

    public SingleConnectionFactory102() {
    }

    public SingleConnectionFactory102(ConnectionFactory connectionFactory, boolean pubSubDomain) {
        this.setTargetConnectionFactory(connectionFactory);
        this.pubSubDomain = pubSubDomain;
        this.afterPropertiesSet();
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.isPubSubDomain()) {
            if (!(this.getTargetConnectionFactory() instanceof TopicConnectionFactory)) {
                throw new IllegalArgumentException("Specified a Spring JMS 1.0.2 SingleConnectionFactory for topics but did not supply an instance of TopicConnectionFactory");
            }
        } else if (!(this.getTargetConnectionFactory() instanceof QueueConnectionFactory)) {
            throw new IllegalArgumentException("Specified a Spring JMS 1.0.2 SingleConnectionFactory for queues but did not supply an instance of QueueConnectionFactory");
        }
    }

    protected Connection doCreateConnection() throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicConnectionFactory)this.getTargetConnectionFactory()).createTopicConnection();
        }
        return ((QueueConnectionFactory)this.getTargetConnectionFactory()).createQueueConnection();
    }
}

