/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.stjs.generator.ClassWithJavascript;

public class DependencyCollector {
    private final DependencyComparator dependencyComparator = new DependencyComparator();
    private final ClassWithJavascriptComparator classWithJsComparator = new ClassWithJavascriptComparator(this.dependencyComparator);

    private int compareDeps(int withIndex, List<ClassWithJavascript> deps, Comparator<ClassWithJavascript> comparator) {
        for (int j = 0; j < deps.size(); ++j) {
            int cmp;
            if (withIndex == j || (cmp = comparator.compare(deps.get(withIndex), deps.get(j))) <= 0) continue;
            return cmp;
        }
        return -1;
    }

    public List<ClassWithJavascript> orderAllDependencies(ClassWithJavascript root) {
        return this.orderAllDependencies(Collections.singletonList(root));
    }

    public List<ClassWithJavascript> orderAllDependencies(List<ClassWithJavascript> roots) {
        ArrayList<ClassWithJavascript> deps = new ArrayList<ClassWithJavascript>();
        HashSet<ClassWithJavascript> visited = new HashSet<ClassWithJavascript>();
        for (ClassWithJavascript root : roots) {
            this.visit(visited, new LinkedHashSet<ClassWithJavascript>(), deps, root);
        }
        ArrayList<ClassWithJavascript> orderedDeps = new ArrayList<ClassWithJavascript>();
        while (!deps.isEmpty()) {
            for (int i = 0; i < deps.size(); ++i) {
                if (this.compareDeps(i, deps, this.classWithJsComparator) > 0) continue;
                orderedDeps.add((ClassWithJavascript)deps.remove(i));
                --i;
            }
        }
        return orderedDeps;
    }

    private void visit(Set<ClassWithJavascript> visited, Set<ClassWithJavascript> path, List<ClassWithJavascript> deps, ClassWithJavascript cj) {
        if (path.contains(cj)) {
            return;
        }
        if (!visited.contains(cj)) {
            visited.add(cj);
            path.add(cj);
            for (ClassWithJavascript dep : cj.getDirectDependencies()) {
                this.visit(visited, path, deps, dep);
                path.remove(dep);
            }
            deps.add(cj);
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="This comparator will not be used with Serializable lists")
    static class ClassWithJavascriptComparator
    implements Comparator<ClassWithJavascript> {
        private final DependencyComparator dependencyComparator;

        ClassWithJavascriptComparator(DependencyComparator dependencyComparator) {
            this.dependencyComparator = dependencyComparator;
        }

        @Override
        public int compare(ClassWithJavascript o1, ClassWithJavascript o2) {
            return this.dependencyComparator.compare(o1.getJavaClass(), o2.getJavaClass());
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="This comparator will not be used with Serializable lists")
    public static class DependencyComparator
    implements Comparator<Class<?>> {
        private final ConcurrentHashMap<Class<?>, Class<?>[]> declaredClasses = new ConcurrentHashMap();

        @Override
        public int compare(Class<?> a, Class<?> b) {
            return this.tryCompare(a, b, true);
        }

        private int tryCompare(Class<?> a, Class<?> b, boolean checkInverse) {
            if (a.equals(b)) {
                return 0;
            }
            int direct = this.getAssignationDirection(a, b);
            if (!checkInverse) {
                return direct;
            }
            int inverse = this.tryCompare(b, a, false);
            if (direct == -1 && inverse == -1) {
                throw new IllegalArgumentException("Cannot decide the dependency order between the types:" + a + " and " + b);
            }
            if (direct != 0) {
                return direct;
            }
            return -inverse;
        }

        private int getAssignationDirection(Class<?> a, Class<?> b) {
            int direct = 0;
            if (this.isAssignableFromTypeOrChildTypes(a, b)) {
                direct = -1;
            } else {
                for (Class<?> child : this.getDeclaredClasses(a)) {
                    if (!this.isAssignableFromTypeOrChildTypes(child, b)) continue;
                    direct = -1;
                    break;
                }
            }
            return direct;
        }

        private boolean isAssignableFromTypeOrChildTypes(Class<?> a, Class<?> b) {
            if (a.isAssignableFrom(b)) {
                return true;
            }
            for (Class<?> child : this.getDeclaredClasses(b)) {
                if (!this.isAssignableFromTypeOrChildTypes(a, child)) continue;
                return true;
            }
            return false;
        }

        private Class<?>[] getDeclaredClasses(Class<?> clazz) {
            Class<?>[] original;
            Class<?>[] classes = this.declaredClasses.get(clazz);
            if (classes == null && (original = this.declaredClasses.putIfAbsent(clazz, classes = clazz.getDeclaredClasses())) != null) {
                return original;
            }
            return classes;
        }
    }
}

