/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator;

import com.google.common.collect.Maps;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.stjs.generator.GeneratorConfiguration;
import org.stjs.generator.JavascriptFileGenerationException;
import org.stjs.generator.SourcePosition;
import org.stjs.generator.check.Checks;
import org.stjs.generator.javac.AnnotationHelper;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.javascript.JavaScriptBuilder;
import org.stjs.generator.name.JavaScriptNameProvider;
import org.stjs.generator.visitor.TreePathHolder;

public class GenerationContext<JS>
implements TreePathHolder {
    private static final Object NULL = new Object();
    private final File inputFile;
    private final GeneratorConfiguration configuration;
    private final JavaScriptNameProvider names;
    private Trees trees;
    private Elements elements;
    private Types types;
    private TreePath currentPath;
    private final Checks checks;
    private CompilationUnitTree compilationUnit;
    private final JavaScriptBuilder<JS> javaScriptBuilder;
    private SourceMapGenerator sourceMapGenerator;
    private final Map<AnnotationCacheKey, Object> cacheAnnotations;
    private final Map<Tree, TreeWrapper<?, JS>> cacheWrappers = Maps.newIdentityHashMap();
    private final Map<Element, TreeWrapper<?, JS>> cacheWrappersByElement = Maps.newIdentityHashMap();

    public GenerationContext(File inputFile, GeneratorConfiguration configuration, JavaScriptNameProvider names, Trees trees, Map<AnnotationCacheKey, Object> cacheAnnotations, JavaScriptBuilder<JS> javaScriptBuilder) {
        this.inputFile = inputFile;
        this.configuration = configuration;
        this.names = names;
        this.trees = trees;
        this.checks = new Checks();
        this.javaScriptBuilder = javaScriptBuilder;
        this.cacheAnnotations = cacheAnnotations;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public GeneratorConfiguration getConfiguration() {
        return this.configuration;
    }

    public JavaScriptNameProvider getNames() {
        return this.names;
    }

    public Trees getTrees() {
        return this.trees;
    }

    public void setTrees(Trees trees) {
        this.trees = trees;
    }

    @Override
    public TreePath getCurrentPath() {
        return this.currentPath;
    }

    @Override
    public void setCurrentPath(TreePath currentPath) {
        this.currentPath = currentPath;
    }

    public Elements getElements() {
        return this.elements;
    }

    public void setElements(Elements elements) {
        this.elements = elements;
    }

    public Types getTypes() {
        return this.types;
    }

    public void setTypes(Types types) {
        this.types = types;
    }

    public Checks getChecks() {
        return this.checks;
    }

    public CompilationUnitTree getCompilationUnit() {
        return this.compilationUnit;
    }

    public void setCompilationUnit(CompilationUnitTree compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public JavascriptFileGenerationException addError(Tree tree, String message) {
        if (this.compilationUnit == null) {
            return new JavascriptFileGenerationException(new SourcePosition(this.inputFile, 0, 0), message);
        }
        long startPos = this.trees.getSourcePositions().getStartPosition(this.compilationUnit, tree);
        SourcePosition pos = startPos >= 0L ? new SourcePosition(this.inputFile, (int)this.compilationUnit.getLineMap().getLineNumber(startPos), (int)this.compilationUnit.getLineMap().getColumnNumber(startPos)) : new SourcePosition(this.inputFile, 0, 0);
        JavascriptFileGenerationException ex = new JavascriptFileGenerationException(pos, message);
        this.checks.addError(ex);
        return ex;
    }

    public JS withPosition(Tree tree, JS node) {
        if (this.compilationUnit == null) {
            return node;
        }
        long startPos = this.trees.getSourcePositions().getStartPosition(this.compilationUnit, tree);
        int line = startPos >= 0L ? (int)this.compilationUnit.getLineMap().getLineNumber(startPos) : 0;
        int column = startPos >= 0L ? (int)this.compilationUnit.getLineMap().getColumnNumber(startPos) : 0;
        long endPos = this.trees.getSourcePositions().getEndPosition(this.compilationUnit, tree);
        int endLine = endPos >= 0L ? (int)this.compilationUnit.getLineMap().getLineNumber(endPos) : 0;
        int endColumn = endPos >= 0L ? (int)this.compilationUnit.getLineMap().getColumnNumber(endPos) : 0;
        return this.javaScriptBuilder.position(node, line, column, endLine, endColumn);
    }

    public int getStartLine(Tree tree) {
        if (this.compilationUnit == null) {
            return -1;
        }
        long startPos = this.trees.getSourcePositions().getStartPosition(this.compilationUnit, tree);
        return (int)(startPos >= 0L ? this.compilationUnit.getLineMap().getLineNumber(startPos) : 0L);
    }

    public JavaScriptBuilder<JS> js() {
        return this.javaScriptBuilder;
    }

    public void writeJavaScript(JS astRoot, Writer writer) {
        this.sourceMapGenerator = this.javaScriptBuilder.writeJavaScript(astRoot, this.inputFile, this.configuration.isGenerateSourceMap(), writer);
    }

    public void writeSourceMap(Writer sourceMapWriter) throws IOException {
        if (this.sourceMapGenerator == null) {
            throw new IllegalStateException("Cannot call this method for writer that do not generate source maps");
        }
        this.sourceMapGenerator.appendTo((Appendable)sourceMapWriter, this.inputFile.getName().replaceAll("\\.java$", ".js"));
    }

    public <T extends Tree> TreeWrapper<T, JS> getCurrentWrapper() {
        return this.wrap(this.currentPath);
    }

    public <T extends Tree> TreeWrapper<T, JS> wrap(TreePath path) {
        TreeWrapper<Object, JS> tw = this.cacheWrappers.get(path.getLeaf());
        if (tw == null) {
            tw = new TreeWrapper(path, this);
            this.cacheWrappers.put(path.getLeaf(), tw);
        }
        return tw;
    }

    private TreePath getTreePath(Element enclosingElement) {
        TreePath path = this.trees.getPath(enclosingElement);
        if (path == null) {
            Tree tree = this.trees.getTree(enclosingElement);
            if (tree == null) {
                tree = new DummyTree();
            }
            path = new TreePath(new TreePath(this.compilationUnit), tree);
        }
        return path;
    }

    public <T extends Tree> TreeWrapper<T, JS> wrap(Element enclosingElement) {
        TreeWrapper<Object, JS> tw = this.cacheWrappersByElement.get(enclosingElement);
        if (tw == null) {
            tw = new TreeWrapper(enclosingElement, this.getTreePath(enclosingElement), this);
            this.cacheWrappersByElement.put(enclosingElement, tw);
        }
        return tw;
    }

    public ClassLoader getBuiltProjectClassLoader() {
        return this.configuration.getStjsClassLoader();
    }

    public <T extends Annotation> T getAnnotation(Element element, Class<T> annotationType) {
        AnnotationCacheKey key = new AnnotationCacheKey(annotationType, element);
        Object ret = this.cacheAnnotations.get(key);
        if (ret != null) {
            return (T)(NULL.equals(ret) ? null : (Annotation)ret);
        }
        ret = AnnotationHelper.getAnnotation(this.elements, element, annotationType);
        if (ret == null) {
            this.cacheAnnotations.put(key, NULL);
        } else {
            this.cacheAnnotations.put(key, ret);
        }
        return (T)((Annotation)ret);
    }

    public static class DummyTree
    implements Tree {
        @Override
        public <R, D> R accept(TreeVisitor<R, D> arg0, D arg1) {
            return null;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ERRONEOUS;
        }
    }

    public static class AnnotationCacheKey {
        private final Class<? extends Annotation> annotationType;
        private final Element element;

        public AnnotationCacheKey(Class<? extends Annotation> annotationType, Element element) {
            this.annotationType = annotationType;
            this.element = element;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.annotationType == null ? 0 : this.annotationType.hashCode());
            result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnnotationCacheKey other = (AnnotationCacheKey)obj;
            if (this.annotationType == null ? other.annotationType != null : !this.annotationType.equals(other.annotationType)) {
                return false;
            }
            return !(this.element == null ? other.element != null : !this.element.equals(other.element));
        }
    }
}

