/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator;

import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTool;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.stjs.generator.BridgeClass;
import org.stjs.generator.ClassWithJavascript;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.GeneratorConfiguration;
import org.stjs.generator.JavascriptFileGenerationException;
import org.stjs.generator.STJSClass;
import org.stjs.generator.STJSRuntimeException;
import org.stjs.generator.SourcePosition;
import org.stjs.generator.javac.CustomClassloaderJavaFileManager;
import org.stjs.generator.javascript.JavaScriptBuilder;
import org.stjs.generator.javascript.rhino.RhinoJavaScriptBuilder;
import org.stjs.generator.name.DefaultJavaScriptNameProvider;
import org.stjs.generator.name.DependencyType;
import org.stjs.generator.plugin.GenerationPlugins;
import org.stjs.generator.utils.ClassUtils;
import org.stjs.generator.utils.Timers;

public class Generator {
    private static final Logger LOG = Logger.getLogger(Generator.class.getName());
    private static final int EXECUTOR_TERMINAL_TIMEOUT = 10;
    private static final String STJS_FILE = "stjs.js";
    private final GenerationPlugins<Object> plugins;
    private StandardJavaFileManager fileManager;
    private JavaFileManager classLoaderFileManager;
    private final Map<GenerationContext.AnnotationCacheKey, Object> cacheAnnotations = Maps.newHashMap();
    private final Executor taskExecutor;
    private final GeneratorConfiguration config;

    public Generator(GeneratorConfiguration config) {
        this.plugins = new GenerationPlugins();
        this.config = config;
        this.taskExecutor = new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        };
    }

    @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void close() {
        try {
            Closeables.close((Closeable)this.fileManager, (boolean)true);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "IOException should not have been thrown.", e);
        }
        if (this.taskExecutor instanceof ExecutorService) {
            ExecutorService es = (ExecutorService)this.taskExecutor;
            es.shutdown();
            try {
                es.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public File getOutputFile(File generationFolder, String className) {
        return this.getOutputFile(generationFolder, className, true);
    }

    private File getSourceMapFile(String className) {
        return new File(this.config.getGenerationFolder().getGeneratedSourcesAbsolutePath(), className.replace('.', File.separatorChar) + ".map");
    }

    public File getOutputFile(File generationFolder, String className, boolean generateDirectory) {
        File output = new File(generationFolder, className.replace('.', File.separatorChar) + ".js");
        if (generateDirectory && !output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
            throw new STJSRuntimeException("Unable to create parent folder for the output file:" + output);
        }
        return output;
    }

    private File getInputFile(File sourceFolder, String className) {
        return new File(sourceFolder, className.replace('.', File.separatorChar) + ".java");
    }

    private JavaScriptBuilder<Object> getJavaScriptBuilder() {
        return new RhinoJavaScriptBuilder();
    }

    public ClassWithJavascript generateJavascript(String className, File sourceFolder) throws JavascriptFileGenerationException {
        Class<?> clazz = ClassUtils.getClazz(this.config.getStjsClassLoader(), className);
        if (ClassUtils.isBridge(this.config.getStjsClassLoader(), clazz)) {
            return new BridgeClass(this.config.getClassResolver(), clazz);
        }
        File inputFile = this.getInputFile(sourceFolder, className);
        File outputFile = this.getOutputFile(this.config.getGenerationFolder().getGeneratedSourcesAbsolutePath(), className);
        DefaultJavaScriptNameProvider names = new DefaultJavaScriptNameProvider();
        GenerationPlugins<Object> currentClassPlugins = this.plugins.forClass(clazz);
        GenerationContext<Object> context = new GenerationContext<Object>(inputFile, this.config, names, null, this.cacheAnnotations, this.getJavaScriptBuilder());
        CompilationUnitTree cu = this.parseAndResolve(inputFile, context, this.config.getStjsClassLoader(), this.config.getSourceEncoding());
        Timers.start("check-java");
        currentClassPlugins.getCheckVisitor().scan((Tree)cu, context);
        context.getChecks().check();
        Timers.end("check-java");
        Timers.start("write-js-ast");
        Object javascriptRoot = currentClassPlugins.getWriterVisitor().scan((Tree)cu, context);
        context.getChecks().check();
        Timers.end("write-js-ast");
        Class<?> javaClass = this.config.getClassResolver().resolveJavaClass(className);
        STJSClass stjsClass = new STJSClass(this.config.getClassResolver(), this.config.getTargetFolder(), javaClass);
        LinkedHashMap<String, DependencyType> resolvedClasses = new LinkedHashMap<String, DependencyType>(names.getResolvedTypes());
        resolvedClasses.remove(className);
        stjsClass.setDependencies(resolvedClasses);
        stjsClass.setGeneratedJavascriptFile(this.getRuntimeUri(className));
        TypeElement classElement = context.getElements().getTypeElement(clazz.getCanonicalName());
        stjsClass.setJavascriptNamespace(context.wrap(classElement).getNamespace());
        this.taskExecutor.execute(new DumpFilesTask<Object>(outputFile, context, javascriptRoot, stjsClass));
        return stjsClass;
    }

    private URI getRuntimeUri(String className) {
        String jsFilePath = className.replace('.', '/') + ".js";
        return this.config.getGenerationFolder().getGeneratedSourcesRuntimePath().resolve(jsFilePath);
    }

    private JavaCompiler getCompiler(ClassLoader builtProjectClassLoader, String sourceEncoding) {
        JavacTool compiler = JavacTool.create();
        if (compiler == null) {
            throw new STJSRuntimeException("A Java compiler is not available for this project. You may have configured your environment to run with JRE instead of a JDK");
        }
        if (this.fileManager == null) {
            this.fileManager = compiler.getStandardFileManager(null, null, Charset.forName(sourceEncoding));
            this.classLoaderFileManager = new CustomClassloaderJavaFileManager(builtProjectClassLoader, this.fileManager);
        }
        return compiler;
    }

    private <JS> CompilationUnitTree parseAndResolve(File inputFile, GenerationContext<JS> context, ClassLoader builtProjectClassLoader, String sourceEncoding) {
        JavaCompiler.CompilationTask task = null;
        JavacTask javacTask = null;
        try {
            JavaCompiler compiler = this.getCompiler(builtProjectClassLoader, sourceEncoding);
            Iterable<? extends JavaFileObject> fileObjects = this.fileManager.getJavaFileObjectsFromFiles(Collections.singleton(inputFile));
            List<String> options = Arrays.asList("-proc:none");
            task = compiler.getTask(null, this.classLoaderFileManager, null, options, null, fileObjects);
            javacTask = (JavacTask)task;
            context.setTrees(Trees.instance(javacTask));
            context.setElements(javacTask.getElements());
            context.setTypes(javacTask.getTypes());
            Timers.start("parse-java");
            CompilationUnitTree cu = javacTask.parse().iterator().next();
            Timers.end("parse-java");
            Timers.start("analyze-java");
            javacTask.analyze();
            Timers.end("analyze-java");
            context.setCompilationUnit(cu);
            return cu;
        }
        catch (Throwable e) {
            throw new JavascriptFileGenerationException(new SourcePosition(context.getInputFile(), 0, 0), "Cannot parse the Java file", e);
        }
    }

    public void copyJavascriptSupport(File folder) {
        InputStream stjs = Thread.currentThread().getContextClassLoader().getResourceAsStream(STJS_FILE);
        if (stjs == null) {
            throw new STJSRuntimeException("stjs.js is missing from the Generator's classpath");
        }
        File outputFile = new File(folder, STJS_FILE);
        try {
            Files.copy((InputSupplier)new InputStreamSupplier(stjs), (File)outputFile);
        }
        catch (IOException e) {
            throw new STJSRuntimeException("Could not copy the stjs.js file to the folder " + folder + ":" + e.getMessage(), e);
        }
        finally {
            Closeables.closeQuietly((InputStream)stjs);
        }
    }

    public ClassWithJavascript getExistingStjsClass(ClassLoader classLoader, Class<?> testClass) {
        return this.config.getClassResolver().resolve(testClass.getName());
    }

    private class DumpFilesTask<JS>
    implements Runnable {
        private final File outputFile;
        private final GenerationContext<JS> context;
        private final JS javascriptRoot;
        private final STJSClass stjsClass;

        public DumpFilesTask(File outputFile, GenerationContext<JS> context, JS javascriptRoot, STJSClass stjsClass) {
            this.outputFile = outputFile;
            this.context = context;
            this.javascriptRoot = javascriptRoot;
            this.stjsClass = stjsClass;
        }

        @Override
        public void run() {
            this.writeJavaScript();
            this.writePropertiesFile();
            this.writeSourceMap();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void writeJavaScript() {
            BufferedWriter writer = null;
            try {
                Timers.start("dump-js");
                writer = Files.newWriter((File)this.outputFile, (Charset)Charset.forName(Generator.this.config.getSourceEncoding()));
                this.context.writeJavaScript(this.javascriptRoot, writer);
                writer.flush();
                Timers.end("dump-js");
            }
            catch (IOException e) {
                try {
                    throw new STJSRuntimeException("Could not open output file " + this.outputFile + ":" + e, e);
                }
                catch (Throwable throwable) {
                    try {
                        Closeables.close(writer, (boolean)true);
                        throw throwable;
                    }
                    catch (IOException e2) {
                        LOG.log(Level.SEVERE, "IOException should not have been thrown.", e2);
                    }
                    throw throwable;
                }
            }
            try {
                Closeables.close((Closeable)writer, (boolean)true);
                return;
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "IOException should not have been thrown.", e);
                return;
            }
        }

        private void writePropertiesFile() {
            Timers.start("write-props");
            this.stjsClass.store();
            Timers.end("write-props");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void writeSourceMap() {
            if (!Generator.this.config.isGenerateSourceMap()) return;
            BufferedWriter sourceMapWriter = null;
            try {
                sourceMapWriter = Files.newWriter((File)Generator.this.getSourceMapFile(this.stjsClass.getJavaClassName()), (Charset)Charset.forName(Generator.this.config.getSourceEncoding()));
                this.context.writeSourceMap(sourceMapWriter);
                sourceMapWriter.flush();
                Files.copy((File)this.context.getInputFile(), (File)new File(this.outputFile.getParentFile(), this.context.getInputFile().getName()));
                File stjsPropFile = this.stjsClass.getStjsPropertiesFile();
                File copyStjsPropFile = new File(Generator.this.config.getGenerationFolder().getGeneratedSourcesAbsolutePath(), ClassUtils.getPropertiesFileName(this.stjsClass.getJavaClassName()));
                if (!stjsPropFile.equals(copyStjsPropFile)) {
                    Files.copy((File)stjsPropFile, (File)copyStjsPropFile);
                }
                if (sourceMapWriter == null) return;
            }
            catch (IOException e) {
                try {
                    throw new STJSRuntimeException("Could generate source map:" + e, e);
                }
                catch (Throwable throwable) {
                    if (sourceMapWriter == null) throw throwable;
                    try {
                        Closeables.close(sourceMapWriter, (boolean)true);
                        throw throwable;
                    }
                    catch (IOException e2) {
                        LOG.log(Level.SEVERE, "IOException should not have been thrown.", e2);
                    }
                    throw throwable;
                }
            }
            try {
                Closeables.close((Closeable)sourceMapWriter, (boolean)true);
                return;
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "IOException should not have been thrown.", e);
                return;
            }
        }
    }

    private static final class InputStreamSupplier
    implements InputSupplier<InputStream> {
        private final InputStream input;

        public InputStreamSupplier(InputStream input) {
            this.input = input;
        }

        public InputStream getInput() throws IOException {
            return this.input;
        }
    }
}

