/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.stjs.generator.ClassResolver;
import org.stjs.generator.DefaultClassResolver;
import org.stjs.generator.GenerationDirectory;
import org.stjs.generator.GeneratorConfiguration;

public class GeneratorConfigurationBuilder {
    private final Collection<String> allowedPackages = new HashSet<String>();
    private final Set<String> allowedJavaLangClasses = new HashSet<String>();
    private final Set<String> annotations = new HashSet<String>();
    private boolean generateArrayHasOwnProperty = true;
    private boolean generateSourceMap;
    private String sourceEncoding = Charset.defaultCharset().name();
    private ClassLoader stjsClassLoader;
    private File targetFolder;
    private GenerationDirectory generationFolder;
    private ClassResolver classResolver;

    public GeneratorConfigurationBuilder() {
    }

    public GeneratorConfigurationBuilder(GeneratorConfiguration baseConfig) {
        this();
        if (baseConfig != null) {
            this.allowedPackages(baseConfig.getAllowedPackages());
            this.allowedJavaLangClasses(baseConfig.getAllowedJavaLangClasses());
            this.annotations(baseConfig.getAnnotations());
            this.generateArrayHasOwnProperty(baseConfig.isGenerateArrayHasOwnProperty());
            this.generateSourceMap(baseConfig.isGenerateSourceMap());
            this.sourceEncoding(baseConfig.getSourceEncoding());
            this.stjsClassLoader(baseConfig.getStjsClassLoader());
            this.targetFolder(baseConfig.getTargetFolder());
            this.generationFolder(baseConfig.getGenerationFolder());
            this.classResolver(baseConfig.getClassResolver());
        }
    }

    public GeneratorConfigurationBuilder allowedPackage(String packageName) {
        this.allowedPackages.add(packageName);
        return this;
    }

    public GeneratorConfigurationBuilder allowedJavaLangClasses(String className) {
        this.allowedJavaLangClasses.add(className);
        return this;
    }

    public GeneratorConfigurationBuilder allowedPackages(Collection<String> packageNames) {
        this.allowedPackages.addAll(packageNames);
        return this;
    }

    public GeneratorConfigurationBuilder allowedJavaLangClasses(Collection<String> classNames) {
        this.allowedJavaLangClasses.addAll(classNames);
        return this;
    }

    public GeneratorConfigurationBuilder generateArrayHasOwnProperty(boolean b) {
        this.generateArrayHasOwnProperty = b;
        return this;
    }

    public GeneratorConfigurationBuilder generateSourceMap(boolean b) {
        this.generateSourceMap = b;
        return this;
    }

    public GeneratorConfigurationBuilder sourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
        return this;
    }

    public GeneratorConfigurationBuilder annotations(String ... annotationNames) {
        this.annotations.addAll(Arrays.asList(annotationNames));
        return this;
    }

    public GeneratorConfigurationBuilder annotations(Collection<String> annotationNames) {
        this.annotations.addAll(annotationNames);
        return this;
    }

    public GeneratorConfigurationBuilder stjsClassLoader(ClassLoader stjsClassLoader) {
        this.stjsClassLoader = stjsClassLoader;
        return this;
    }

    public GeneratorConfigurationBuilder targetFolder(File targetFolder) {
        this.targetFolder = targetFolder;
        return this;
    }

    public GeneratorConfigurationBuilder generationFolder(GenerationDirectory generationFolder) {
        this.generationFolder = generationFolder;
        return this;
    }

    public GeneratorConfigurationBuilder classResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
        return this;
    }

    public GeneratorConfiguration build() {
        this.allowedJavaLangClasses.add("Object");
        this.allowedJavaLangClasses.add("Class");
        this.allowedJavaLangClasses.add("String");
        this.allowedJavaLangClasses.add("Number");
        this.allowedJavaLangClasses.add("Double");
        this.allowedJavaLangClasses.add("Float");
        this.allowedJavaLangClasses.add("Long");
        this.allowedJavaLangClasses.add("Integer");
        this.allowedJavaLangClasses.add("Short");
        this.allowedJavaLangClasses.add("Boolean");
        this.allowedJavaLangClasses.add("Character");
        this.allowedJavaLangClasses.add("Byte");
        this.allowedJavaLangClasses.add("Void");
        this.allowedJavaLangClasses.add("Math");
        this.allowedJavaLangClasses.add("Throwable");
        this.allowedJavaLangClasses.add("Exception");
        this.allowedJavaLangClasses.add("RuntimeException");
        this.allowedPackages.add("java.lang");
        return new GeneratorConfiguration(this.allowedPackages, this.allowedJavaLangClasses, this.generateArrayHasOwnProperty, this.generateSourceMap, this.sourceEncoding, this.annotations, this.stjsClassLoader, this.targetFolder, this.generationFolder, this.classResolver == null ? new DefaultClassResolver(this.stjsClassLoader) : this.classResolver);
    }
}

