/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.stjs.generator.STJSRuntimeException;
import org.stjs.javascript.annotation.Namespace;

public final class NamespaceUtil {
    private NamespaceUtil() {
    }

    public static String resolveNamespace(Class<?> clazz) {
        String ns = NamespaceUtil.resolveNamespaceSimple(clazz);
        if (ns == null && clazz.getPackage() != null) {
            return NamespaceUtil.resolvePackageNamespace(clazz.getPackage().getName(), clazz.getClassLoader());
        }
        return ns;
    }

    public static String resolveNamespace(String className, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(className, false, classLoader);
            return NamespaceUtil.resolveNamespace(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            throw new STJSRuntimeException(cnfe);
        }
    }

    public static String resolvePackageNamespace(String packageName, ClassLoader classLoader) {
        String ns;
        Package pack = NamespaceUtil.getPackage(packageName, classLoader);
        if (pack != null && (ns = NamespaceUtil.getNamespaceAnnotationValue(pack, classLoader)) != null) {
            return ns;
        }
        int lastDotIndex = packageName.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return null;
        }
        return NamespaceUtil.resolvePackageNamespace(packageName.substring(0, lastDotIndex), classLoader);
    }

    public static String resolveNamespaceSimple(String className, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(className, false, classLoader);
            return NamespaceUtil.resolveNamespaceSimple(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            throw new STJSRuntimeException(cnfe);
        }
    }

    public static String resolveNamespaceSimple(Class<?> clazz) {
        String ns = NamespaceUtil.getNamespaceAnnotationValue(clazz, clazz.getClassLoader());
        if (ns != null) {
            return ns;
        }
        return NamespaceUtil.getNamespacePropertyValue(clazz);
    }

    private static String getNamespacePropertyValue(Class<?> clazz) {
        if (clazz.getClassLoader() == null) {
            return null;
        }
        String propertiesPath = clazz.getName().replace(".", "/") + ".stjs";
        InputStream in = clazz.getClassLoader().getResourceAsStream(propertiesPath);
        if (in == null) {
            return null;
        }
        try {
            Properties props = new Properties();
            props.load(in);
            return props.getProperty("jsNamespace");
        }
        catch (IOException e) {
            throw new STJSRuntimeException(e);
        }
    }

    private static String getNamespaceAnnotationValue(AnnotatedElement element, ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        try {
            Annotation annotation = element.getAnnotation(NamespaceUtil.getNamespaceClass(classLoader));
            if (annotation == null) {
                return null;
            }
            return (String)annotation.getClass().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new STJSRuntimeException(e);
        }
    }

    private static Class<? extends Annotation> getNamespaceClass(ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(Namespace.class.getName(), true, classLoader);
    }

    private static Package getPackage(String packageName, ClassLoader classLoader) {
        Class<?> clazz;
        try {
            clazz = Class.forName(packageName + ".package-info", true, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return clazz.getPackage();
    }
}

