/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.declaration;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.InternalUtils;
import org.stjs.generator.javac.TreeUtils;

public class ClassEnumWithoutMembersCheck
implements CheckContributor<ClassTree> {
    private void checkMember(Tree member, GenerationContext<Void> context) {
        if (InternalUtils.isSyntheticConstructor(member)) {
            return;
        }
        boolean ok = false;
        if (member instanceof VariableTree) {
            VariableElement memberElement = TreeUtils.elementFromDeclaration((VariableTree)member);
            boolean bl = ok = memberElement.getKind() == ElementKind.ENUM_CONSTANT;
        }
        if (!ok) {
            context.addError(member, "Enums with fields or methods are not supported");
        }
    }

    @Override
    public Void visit(CheckVisitor visitor, ClassTree tree, GenerationContext<Void> context) {
        TypeElement typeElement = TreeUtils.elementFromDeclaration(tree);
        if (typeElement.getKind() != ElementKind.ENUM) {
            return null;
        }
        for (Tree tree2 : tree.getMembers()) {
            this.checkMember(tree2, context);
        }
        return null;
    }
}

