/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.expression;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javac.TreeWrapper;

public class IdentifierGlobalScopeNameClashCheck
implements CheckContributor<IdentifierTree> {
    private static MethodTree getEnclosingMethod(TreePath path) {
        for (TreePath p = path.getParentPath(); p != null; p = p.getParentPath()) {
            if (!(p.getLeaf() instanceof MethodTree)) continue;
            return (MethodTree)p.getLeaf();
        }
        return null;
    }

    private static void findVariablesInMethod(final String name, final GenerationContext<Void> context) {
        MethodTree enclosingMethod = IdentifierGlobalScopeNameClashCheck.getEnclosingMethod(context.getCurrentPath());
        if (enclosingMethod == null) {
            return;
        }
        enclosingMethod.accept(new TreeScanner<Void, Void>(){
            private boolean checkStopped;

            @Override
            public Void visitClass(ClassTree arg0, Void arg1) {
                this.checkStopped = true;
                return (Void)super.visitClass(arg0, arg1);
            }

            @Override
            public Void visitVariable(VariableTree var, Void arg1) {
                if (!this.checkStopped && var.getName().toString().equals(name)) {
                    context.addError(var, "A variable with the same name as your global variable is already defined in this method's scope. Please rename either the local variable/parameter or the global variable.");
                }
                return (Void)super.visitVariable(var, arg1);
            }
        }, null);
    }

    public static Void checkGlobalScope(ExpressionTree tree, String name, GenerationContext<Void> context) {
        Element fieldElement = TreeUtils.elementFromUse(tree);
        if (fieldElement == null || fieldElement.getKind() != ElementKind.FIELD) {
            return null;
        }
        if ("this".equals(name)) {
            return null;
        }
        TreeWrapper tw = context.getCurrentWrapper();
        if (!tw.getEnclosingType().isGlobal()) {
            return null;
        }
        IdentifierGlobalScopeNameClashCheck.findVariablesInMethod(name, context);
        return null;
    }

    @Override
    public Void visit(CheckVisitor visitor, IdentifierTree tree, GenerationContext<Void> context) {
        return IdentifierGlobalScopeNameClashCheck.checkGlobalScope(tree, tree.getName().toString(), context);
    }
}

