/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.expression;

import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.InternalUtils;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.writer.expression.MethodInvocationWriter;

public class MethodInvocationSuperSynthCheck
implements CheckContributor<MethodInvocationTree> {
    private boolean checkSuperConstructor(MethodInvocationTree tree, GenerationContext<Void> context) {
        String name = MethodInvocationWriter.buildMethodName(tree);
        if ("super".equals(name)) {
            if (!InternalUtils.isSyntheticConstructor(TreeUtils.enclosingOfKind(context.getCurrentPath(), Tree.Kind.METHOD))) {
                context.addError(tree, "You cannot call the super constructor if that belongs to a @SyntheticType");
            }
            return true;
        }
        return false;
    }

    private boolean checkSuperMethodCall(MethodInvocationTree tree, GenerationContext<Void> context) {
        if (!(tree.getMethodSelect() instanceof MemberSelectTree)) {
            return true;
        }
        MemberSelectTree select = (MemberSelectTree)tree.getMethodSelect();
        if ("super".equals(select.getExpression().toString())) {
            context.addError(tree, "You cannot call the super method if that belongs to a @SyntheticType");
            return true;
        }
        return false;
    }

    @Override
    public Void visit(CheckVisitor visitor, MethodInvocationTree tree, GenerationContext<Void> context) {
        TreeWrapper tw = context.getCurrentWrapper();
        if (!tw.getEnclosingType().isSyntheticType()) {
            return null;
        }
        if (this.checkSuperConstructor(tree, context)) {
            return null;
        }
        this.checkSuperMethodCall(tree, context);
        return null;
    }
}

