/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.executor;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.stjs.generator.STJSRuntimeException;
import org.stjs.generator.executor.ExecutionResult;

public class NodeJSExecutor {
    private static final String NODE_JS = "node";

    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"})
    public ExecutionResult run(File srcFile) {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{NODE_JS, srcFile.getAbsolutePath()});
            int exitValue = p.waitFor();
            return new ExecutionResult(null, this.readStream(p.getInputStream()), this.readStream(p.getErrorStream()), exitValue);
        }
        catch (IOException e) {
            if (e.getMessage().contains("Cannot run program")) {
                String errMsg = "Please install node.js to use this feature https://github.com/joyent/node/wiki/Installation";
                throw new STJSRuntimeException(errMsg, e);
            }
            throw new STJSRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new STJSRuntimeException(e);
        }
    }

    private String readStream(InputStream errStream) throws IOException {
        StringBuilder builder = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(errStream, "UTF-8"));
        String line = in.readLine();
        while (line != null) {
            builder.append(line);
            builder.append('\n');
            line = in.readLine();
        }
        return builder.toString();
    }
}

