/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.javac;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.NamespaceUtil;
import org.stjs.generator.javac.ElementUtils;
import org.stjs.generator.javac.InternalUtils;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javac.TypesUtils;
import org.stjs.generator.name.DependencyType;
import org.stjs.javascript.annotation.DataType;
import org.stjs.javascript.annotation.GlobalScope;
import org.stjs.javascript.annotation.JavascriptFunction;
import org.stjs.javascript.annotation.Namespace;
import org.stjs.javascript.annotation.Native;
import org.stjs.javascript.annotation.ServerSide;
import org.stjs.javascript.annotation.SyntheticType;
import org.stjs.javascript.annotation.Template;

public class TreeWrapper<T extends Tree, JS> {
    private final TreePath path;
    private final GenerationContext<JS> context;
    private final Element element;
    private String jsNamespace;

    public TreeWrapper(@Nonnull TreePath path, @Nonnull GenerationContext<JS> context) {
        this.context = context;
        this.path = path;
        this.element = this.getElement(path.getLeaf());
    }

    public TreeWrapper(@Nonnull Element element, @Nonnull TreePath path, @Nonnull GenerationContext<JS> context) {
        this.context = context;
        this.path = path;
        this.element = element;
    }

    private Element getElement(Tree tree) {
        return InternalUtils.symbol(tree);
    }

    public T getTree() {
        return (T)this.path.getLeaf();
    }

    public TreePath getPath() {
        return this.path;
    }

    public GenerationContext<JS> getContext() {
        return this.context;
    }

    public boolean isFinal() {
        Set<Modifier> modifiers = this.element.getModifiers();
        return modifiers.contains((Object)Modifier.FINAL);
    }

    public boolean isStatic() {
        Set<Modifier> modifiers = this.element.getModifiers();
        return modifiers.contains((Object)Modifier.STATIC);
    }

    public boolean isAbstract() {
        Set<Modifier> modifiers = this.element.getModifiers();
        return modifiers.contains((Object)Modifier.ABSTRACT);
    }

    public boolean isSuper() {
        if (!(this.getTree() instanceof IdentifierTree)) {
            return false;
        }
        return "super".equals(((IdentifierTree)this.getTree()).getName().toString());
    }

    public boolean isPrimitiveType() {
        return TypesUtils.isPrimitive(this.element.asType());
    }

    private <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        A a = this.element.getAnnotation(annotationType);
        if (a != null) {
            return a;
        }
        PackageElement pack = ElementUtils.enclosingPackage(this.element);
        return pack == null ? null : (A)pack.getAnnotation(annotationType);
    }

    public boolean isJavaScriptFunction() {
        return this.getAnnotation(JavascriptFunction.class) != null;
    }

    public boolean isGlobal() {
        return this.getAnnotation(GlobalScope.class) != null;
    }

    public String getNamespace() {
        if (this.jsNamespace == null) {
            this.jsNamespace = this.doGetNamespace();
        }
        return this.jsNamespace;
    }

    private String doGetNamespace() {
        String ns = this.getNamespaceFromElement();
        if (ns != null) {
            return ns;
        }
        ns = this.getNamespaceByReflection();
        if (ns != null) {
            return ns;
        }
        return "";
    }

    private String getNamespaceByReflection() {
        String ns = null;
        if (this.element instanceof PackageElement) {
            ns = this.getPackageNamespace(((PackageElement)this.element).getQualifiedName().toString());
        } else if (this.element instanceof TypeElement) {
            ns = this.getTypeElementNamespace();
        }
        return ns;
    }

    private String getNamespaceFromElement() {
        Namespace nsAnnotation = this.element.getAnnotation(Namespace.class);
        if (nsAnnotation != null) {
            return nsAnnotation.value();
        }
        return null;
    }

    private String getTypeElementNamespace() {
        TypeElement root = (TypeElement)this.element;
        while (root.getEnclosingElement() instanceof TypeElement) {
            root = (TypeElement)root.getEnclosingElement();
        }
        if (root.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
            return this.getTypeNamespace(root.getQualifiedName().toString());
        }
        return null;
    }

    private String getPackageNamespace(String qualifiedName) {
        return NamespaceUtil.resolvePackageNamespace(qualifiedName, this.context.getBuiltProjectClassLoader());
    }

    private String getTypeNamespace(String qualifiedName) {
        return NamespaceUtil.resolveNamespace(qualifiedName, this.context.getBuiltProjectClassLoader());
    }

    public boolean isInnerType() {
        return this.element.getEnclosingElement().getKind() != ElementKind.PACKAGE;
    }

    public <C extends Tree> TreeWrapper<C, JS> child(C child) {
        return this.context.wrap(new TreePath(this.path, child));
    }

    public <P extends Tree> TreeWrapper<P, JS> parent() {
        if (this.path.getParentPath() != null) {
            return this.context.wrap(this.path.getParentPath());
        }
        return null;
    }

    public boolean isSyntheticType() {
        return this.getAnnotation(SyntheticType.class) != null || this.getAnnotation(DataType.class) != null;
    }

    public boolean isNative() {
        return this.element.getModifiers().contains((Object)Modifier.NATIVE) || this.element.getAnnotation(Native.class) != null;
    }

    public boolean isServerSide() {
        return this.element.getAnnotation(ServerSide.class) != null;
    }

    public boolean isJavaScriptPrimitive() {
        TypeMirror type = this.element.asType();
        return TypesUtils.isPrimitive(type) || TypesUtils.isBoxedPrimitive(type) || TypesUtils.isString(type);
    }

    public Element getElement() {
        return this.element;
    }

    public TreeWrapper<ClassTree, JS> getEnclosingType() {
        return this.context.wrap(this.element.getEnclosingElement());
    }

    public TreeWrapper<ClassTree, JS> getCurrentType() {
        TreePath classPath = TreeUtils.enclosingPathOfType(this.path, ClassTree.class);
        if (classPath == null) {
            return null;
        }
        return this.context.wrap(classPath);
    }

    public String getTypeName(DependencyType depType) {
        return this.context.getNames().getTypeName(this.context, this.element, depType);
    }

    public void addError(String message) {
        this.context.addError((Tree)this.getTree(), message);
    }

    public String getMethodTemplate() {
        return this.stripParameters(this.getTemplateValue());
    }

    public String[] getMethodTemplateParameters() {
        return this.getTemplateParameters(this.getTemplateValue());
    }

    public String getFieldTemplate() {
        if (this.element == null || this.element.getKind() != ElementKind.FIELD) {
            return null;
        }
        return this.stripParameters(this.getTemplateValue());
    }

    public String[] getFieldTemplateParameters() {
        if (this.element == null || this.element.getKind() != ElementKind.FIELD) {
            return new String[0];
        }
        return this.getTemplateParameters(this.getTemplateValue());
    }

    private String stripParameters(String templateValue) {
        if (templateValue == null) {
            return null;
        }
        int paramListIndex = templateValue.indexOf(40);
        if (paramListIndex >= 0) {
            return templateValue.substring(0, paramListIndex).trim();
        }
        return templateValue;
    }

    private String[] getTemplateParameters(String templateValue) {
        if (templateValue == null) {
            return new String[0];
        }
        int paramIndex = templateValue.indexOf(40);
        if (paramIndex < 0) {
            return new String[0];
        }
        String params = templateValue.trim().substring(paramIndex + 1, templateValue.length() - 1);
        return params.split("\\s*,\\s*");
    }

    private String getTemplateValue() {
        Template tpl = this.context.getAnnotation(this.element, Template.class);
        if (tpl == null) {
            return null;
        }
        return tpl.value();
    }
}

