/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.javascript;

import com.sun.source.tree.Tree;
import java.util.EnumMap;
import java.util.Map;
import org.stjs.generator.javascript.BinaryOperator;

public enum AssignOperator {
    ASSIGN(Tree.Kind.ASSIGNMENT, 90, null),
    MULTIPLY_ASSIGNMENT(Tree.Kind.MULTIPLY_ASSIGNMENT, 99, BinaryOperator.MULTIPLY),
    DIVIDE_ASSIGNMENT(Tree.Kind.DIVIDE_ASSIGNMENT, 100, BinaryOperator.DIVIDE),
    REMAINDER_ASSIGNMENT(Tree.Kind.REMAINDER_ASSIGNMENT, 101, BinaryOperator.REMAINDER),
    PLUS_ASSIGNMENT(Tree.Kind.PLUS_ASSIGNMENT, 97, BinaryOperator.PLUS),
    MINUS_ASSIGNMENT(Tree.Kind.MINUS_ASSIGNMENT, 98, BinaryOperator.MINUS),
    LEFT_SHIFT_ASSIGNMENT(Tree.Kind.LEFT_SHIFT_ASSIGNMENT, 94, BinaryOperator.LEFT_SHIFT),
    RIGHT_SHIFT_ASSIGNMENT(Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, 95, BinaryOperator.RIGHT_SHIFT),
    UNSIGNED_RIGHT_SHIFT_ASSIGNMENT(Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, 96, BinaryOperator.UNSIGNED_RIGHT_SHIFT),
    AND_ASSIGNMENT(Tree.Kind.AND_ASSIGNMENT, 93, BinaryOperator.AND),
    XOR_ASSIGNMENT(Tree.Kind.XOR_ASSIGNMENT, 92, BinaryOperator.XOR),
    OR_ASSIGNMENT(Tree.Kind.OR_ASSIGNMENT, 91, BinaryOperator.OR);

    private final Tree.Kind java;
    private final int javaScript;
    private final BinaryOperator binaryOperator;
    private static final Map<Tree.Kind, AssignOperator> BY_JAVA_OPERATOR;

    private AssignOperator(Tree.Kind java, int javaScript, BinaryOperator op) {
        this.java = java;
        this.javaScript = javaScript;
        this.binaryOperator = op;
    }

    public BinaryOperator getBinaryOperator() {
        return this.binaryOperator;
    }

    public Tree.Kind getJava() {
        return this.java;
    }

    public int getJavaScript() {
        return this.javaScript;
    }

    public static AssignOperator valueOf(Tree.Kind javaOperator) {
        return BY_JAVA_OPERATOR.get((Object)javaOperator);
    }

    static {
        BY_JAVA_OPERATOR = new EnumMap<Tree.Kind, AssignOperator>(Tree.Kind.class);
        for (AssignOperator op : AssignOperator.values()) {
            BY_JAVA_OPERATOR.put(op.getJava(), op);
        }
    }
}

