/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.javascript;

import com.sun.source.tree.Tree;
import java.util.EnumMap;
import java.util.Map;

public enum BinaryOperator {
    MULTIPLY(Tree.Kind.MULTIPLY, 23),
    DIVIDE(Tree.Kind.DIVIDE, 24),
    REMAINDER(Tree.Kind.REMAINDER, 25),
    PLUS(Tree.Kind.PLUS, 21),
    MINUS(Tree.Kind.MINUS, 22),
    LEFT_SHIFT(Tree.Kind.LEFT_SHIFT, 18),
    RIGHT_SHIFT(Tree.Kind.RIGHT_SHIFT, 19),
    UNSIGNED_RIGHT_SHIFT(Tree.Kind.UNSIGNED_RIGHT_SHIFT, 20),
    AND(Tree.Kind.AND, 11),
    XOR(Tree.Kind.XOR, 10),
    OR(Tree.Kind.OR, 9),
    LESS_THAN(Tree.Kind.LESS_THAN, 14),
    LESS_THAN_EQUAL(Tree.Kind.LESS_THAN_EQUAL, 15),
    GREATER_THAN(Tree.Kind.GREATER_THAN, 16),
    GREATER_THAN_EQUAL(Tree.Kind.GREATER_THAN_EQUAL, 17),
    EQUAL_TO(Tree.Kind.EQUAL_TO, 12),
    NOT_EQUAL_TO(Tree.Kind.NOT_EQUAL_TO, 13),
    CONDITIONAL_AND(Tree.Kind.CONDITIONAL_AND, 105),
    CONDITIONAL_OR(Tree.Kind.CONDITIONAL_OR, 104),
    COMMA(null, 89);

    private final Tree.Kind java;
    private final int javaScript;
    private static final Map<Tree.Kind, BinaryOperator> BY_JAVA_OPERATOR;

    private BinaryOperator(Tree.Kind java, int javaScript) {
        this.java = java;
        this.javaScript = javaScript;
    }

    public Tree.Kind getJava() {
        return this.java;
    }

    public int getJavaScript() {
        return this.javaScript;
    }

    public static BinaryOperator valueOf(Tree.Kind javaOperator) {
        return BY_JAVA_OPERATOR.get((Object)javaOperator);
    }

    static {
        BY_JAVA_OPERATOR = new EnumMap<Tree.Kind, BinaryOperator>(Tree.Kind.class);
        for (BinaryOperator op : BinaryOperator.values()) {
            if (op.getJava() == null) continue;
            BY_JAVA_OPERATOR.put(op.getJava(), op);
        }
    }
}

