/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.javascript;

import com.sun.source.tree.Tree;
import java.util.EnumMap;
import java.util.Map;

public enum UnaryOperator {
    POSTFIX_INCREMENT(Tree.Kind.POSTFIX_INCREMENT, true, 106),
    POSTFIX_DECREMENT(Tree.Kind.POSTFIX_DECREMENT, true, 107),
    PREFIX_INCREMENT(Tree.Kind.PREFIX_INCREMENT, false, 106),
    PREFIX_DECREMENT(Tree.Kind.PREFIX_DECREMENT, false, 107),
    UNARY_PLUS(Tree.Kind.UNARY_PLUS, false, 21),
    UNARY_MINUS(Tree.Kind.UNARY_MINUS, false, 22),
    BITWISE_COMPLEMENT(Tree.Kind.BITWISE_COMPLEMENT, false, 27),
    LOGICAL_COMPLEMENT(Tree.Kind.LOGICAL_COMPLEMENT, false, 26),
    TYPEOF(null, false, 32),
    DELETE_PROPERTY(null, false, 31);

    private final Tree.Kind java;
    private final boolean postfix;
    private final int javaScript;
    private static final Map<Tree.Kind, UnaryOperator> BY_JAVA_OPERATOR;

    private UnaryOperator(Tree.Kind java, boolean postfix, int operator) {
        this.java = java;
        this.postfix = postfix;
        this.javaScript = operator;
    }

    public boolean isPostfix() {
        return this.postfix;
    }

    public Tree.Kind getJava() {
        return this.java;
    }

    public int getJavaScript() {
        return this.javaScript;
    }

    public static UnaryOperator valueOf(Tree.Kind javaOperator) {
        return BY_JAVA_OPERATOR.get((Object)javaOperator);
    }

    static {
        BY_JAVA_OPERATOR = new EnumMap<Tree.Kind, UnaryOperator>(Tree.Kind.class);
        for (UnaryOperator op : UnaryOperator.values()) {
            if (op.getJava() == null) continue;
            BY_JAVA_OPERATOR.put(op.getJava(), op);
        }
    }
}

