/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.plugin;

import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.stjs.generator.STJSRuntimeException;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.plugin.MainGenerationPlugin;
import org.stjs.generator.plugin.STJSGenerationPlugin;
import org.stjs.generator.writer.WriterVisitor;
import org.stjs.javascript.annotation.UsePlugin;

public class GenerationPlugins<JS> {
    private static final String STJS_PLUGINS_CONFIG_FILE = "META-INF/stjs.plugins";
    private static final String JAVA_VERSION_ENTRY = "java.version";
    private final Map<String, STJSGenerationPlugin<JS>> mandatoryPlugins = new HashMap<String, STJSGenerationPlugin<JS>>();
    private final Map<String, STJSGenerationPlugin<JS>> optionalPlugins = new HashMap<String, STJSGenerationPlugin<JS>>();
    private CheckVisitor checkVisitor = new CheckVisitor();
    private WriterVisitor<JS> writerVisitor = new WriterVisitor();

    public GenerationPlugins() {
        Enumeration<URL> configFiles;
        MainGenerationPlugin<JS> mainPlugin = new MainGenerationPlugin<JS>();
        mainPlugin.contributeCheckVisitor(this.checkVisitor);
        mainPlugin.contributeWriteVisitor(this.writerVisitor);
        this.mandatoryPlugins.put("default", mainPlugin);
        try {
            configFiles = Thread.currentThread().getContextClassLoader().getResources(STJS_PLUGINS_CONFIG_FILE);
        }
        catch (IOException e) {
            throw new STJSRuntimeException(e);
        }
        while (configFiles.hasMoreElements()) {
            this.loadConfigFile(configFiles.nextElement());
        }
    }

    private void loadConfigFile(URL configFile) {
        InputStream input = null;
        try {
            input = configFile.openStream();
            Properties props = new Properties();
            props.load(input);
            String javaVersion = props.getProperty(JAVA_VERSION_ENTRY);
            String runningVersion = System.getProperty(JAVA_VERSION_ENTRY);
            if (this.compareVersion(javaVersion, runningVersion) > 0) {
                return;
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                this.loadPlugin(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        catch (IOException e) {
            throw new STJSRuntimeException(e);
        }
        finally {
            Closeables.closeQuietly((InputStream)input);
        }
    }

    private void loadPlugin(String key, String value) {
        STJSGenerationPlugin plugin;
        if (key.equals(JAVA_VERSION_ENTRY)) {
            return;
        }
        try {
            plugin = (STJSGenerationPlugin)Class.forName(value).newInstance();
        }
        catch (InstantiationException e) {
            throw new STJSRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new STJSRuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new STJSRuntimeException(e);
        }
        if (plugin.loadByDefault()) {
            plugin.contributeCheckVisitor(this.checkVisitor);
            plugin.contributeWriteVisitor(this.writerVisitor);
            this.mandatoryPlugins.put(key, plugin);
        } else {
            this.optionalPlugins.put(key, plugin);
        }
    }

    private int compareVersion(String javaVersion, String runningVersion) {
        if (javaVersion == null) {
            return -1;
        }
        return javaVersion.compareTo(runningVersion);
    }

    public CheckVisitor getCheckVisitor() {
        return this.checkVisitor;
    }

    public WriterVisitor<JS> getWriterVisitor() {
        return this.writerVisitor;
    }

    public GenerationPlugins<JS> forClass(Class<?> clazz) {
        UsePlugin usePlugins = clazz.getAnnotation(UsePlugin.class);
        if (usePlugins == null || usePlugins.value() == null || usePlugins.value().length == 0) {
            return this;
        }
        GenerationPlugins<JS> newPlugins = new GenerationPlugins<JS>();
        newPlugins.checkVisitor = new CheckVisitor(this.checkVisitor);
        newPlugins.writerVisitor = new WriterVisitor<JS>(this.writerVisitor);
        for (String pluginName : usePlugins.value()) {
            STJSGenerationPlugin<JS> plugin = this.optionalPlugins.get(pluginName);
            if (plugin == null) {
                throw new STJSRuntimeException("The class:" + clazz.getName() + " need an unknown Generation Plugin :" + pluginName);
            }
            plugin.contributeCheckVisitor(newPlugins.checkVisitor);
            plugin.contributeWriteVisitor(newPlugins.writerVisitor);
        }
        return newPlugins;
    }
}

