/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.utils;

import java.util.HashMap;
import java.util.Map;

public final class Timers {
    private static Map<String, Timer> timers = new HashMap<String, Timer>();

    private Timers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String name) {
        Map<String, Timer> map = timers;
        synchronized (map) {
            Timer timer = timers.get(name);
            if (timer == null) {
                timer = new Timer();
                timers.put(name, timer);
            }
            timer.start = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void end(String name) {
        Map<String, Timer> map = timers;
        synchronized (map) {
            Timer timer = timers.get(name);
            if (timer != null) {
                timer.end = System.currentTimeMillis();
                timer.total += timer.end - timer.start;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump() {
        Map<String, Timer> map = timers;
        synchronized (map) {
            long total = 0L;
            for (Map.Entry<String, Timer> entry : timers.entrySet()) {
                System.out.println(entry.getKey() + "=" + entry.getValue().getTotal());
                total += entry.getValue().getTotal();
            }
            System.out.println("----------------------------");
            System.out.println("Total:" + total);
        }
    }

    private static class Timer {
        private long total;
        private long start;
        private long end;

        private Timer() {
        }

        public long getTotal() {
            return this.total;
        }
    }
}

