/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.declaration;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.javac.AnnotationHelper;
import org.stjs.generator.javac.ElementUtils;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.javac.TypesUtils;
import org.stjs.generator.javascript.AssignOperator;
import org.stjs.generator.javascript.JavaScriptBuilder;
import org.stjs.generator.javascript.Keyword;
import org.stjs.generator.javascript.NameValue;
import org.stjs.generator.javascript.UnaryOperator;
import org.stjs.generator.name.DependencyType;
import org.stjs.generator.utils.JavaNodes;
import org.stjs.generator.writer.MemberWriters;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;
import org.stjs.javascript.annotation.STJSBridge;
import org.stjs.javascript.annotation.ServerSide;

public class ClassWriter<JS>
implements WriterContributor<ClassTree, JS> {
    private void addNamespace(ClassTree tree, GenerationContext<JS> context, List<JS> stmts) {
        TypeElement type = TreeUtils.elementFromDeclaration(tree);
        if (JavaNodes.isInnerType(type)) {
            return;
        }
        String namespace = context.getCurrentWrapper().getNamespace();
        if (!namespace.isEmpty()) {
            JavaScriptBuilder<JS> js = context.js();
            JS target = js.property(js.name("stjs"), "ns");
            stmts.add(js.expressionStatement(js.functionCall(target, Collections.singleton(js.string(namespace)))));
        }
    }

    private JS getSuperClass(ClassTree clazz, GenerationContext<JS> context) {
        TypeElement type = TreeUtils.elementFromDeclaration(clazz);
        if (clazz.getExtendsClause() == null || type.getKind() == ElementKind.INTERFACE) {
            return context.js().keyword(Keyword.NULL);
        }
        TreeWrapper<Tree, JS> superType = context.getCurrentWrapper().child(clazz.getExtendsClause());
        if (superType.isSyntheticType()) {
            return context.js().keyword(Keyword.NULL);
        }
        DependencyType depType = this.getDependencyTypeForClassDef(type);
        return context.js().name(superType.getTypeName(depType));
    }

    private DependencyType getDependencyTypeForClassDef(Element type) {
        if (JavaNodes.isInnerType(type)) {
            return DependencyType.STATIC;
        }
        return DependencyType.EXTENDS;
    }

    private JS getInterfaces(ClassTree clazz, GenerationContext<JS> context) {
        TreeWrapper<Tree, JS> superType;
        TypeElement type = TreeUtils.elementFromDeclaration(clazz);
        DependencyType depType = this.getDependencyTypeForClassDef(type);
        ArrayList<JS> ifaces = new ArrayList<JS>();
        for (Tree tree : clazz.getImplementsClause()) {
            TreeWrapper<Tree, JS> ifaceType = context.getCurrentWrapper().child(tree);
            if (ifaceType.isSyntheticType()) continue;
            ifaces.add(context.js().name(ifaceType.getTypeName(depType)));
        }
        if (clazz.getExtendsClause() != null && type.getKind() == ElementKind.INTERFACE && !(superType = context.getCurrentWrapper().child(clazz.getExtendsClause())).isSyntheticType()) {
            ifaces.add(0, context.js().name(superType.getTypeName(DependencyType.EXTENDS)));
        }
        return context.js().array(ifaces);
    }

    private JS getConstructor(WriterVisitor<JS> visitor, ClassTree clazz, GenerationContext<JS> context) {
        for (Tree tree : clazz.getMembers()) {
            Object node;
            if (!JavaNodes.isConstructor(tree) || (node = visitor.scan(tree, context)) == null) continue;
            return (JS)node;
        }
        return context.js().function(null, Collections.emptyList(), null);
    }

    private List<Tree> getAllMembersExceptConstructors(ClassTree clazz) {
        ArrayList<Tree> nonConstructors = new ArrayList<Tree>();
        for (Tree tree : clazz.getMembers()) {
            if (JavaNodes.isConstructor(tree) || tree instanceof BlockTree) continue;
            nonConstructors.add(tree);
        }
        return nonConstructors;
    }

    private JS getMembers(WriterVisitor<JS> visitor, ClassTree clazz, GenerationContext<JS> context) {
        List<Tree> nonConstructors = this.getAllMembersExceptConstructors(clazz);
        if (nonConstructors.isEmpty()) {
            return context.js().keyword(Keyword.NULL);
        }
        List<Object> params = Arrays.asList(context.js().name("constructor"), context.js().name("prototype"));
        ArrayList stmts = new ArrayList();
        for (Tree member : nonConstructors) {
            stmts.add(visitor.scan(member, context));
        }
        return (JS)context.js().function(null, params, context.js().block(stmts));
    }

    private void addStaticInitializers(WriterVisitor<JS> visitor, ClassTree tree, GenerationContext<JS> context, List<JS> stmts) {
        for (Tree tree2 : tree.getMembers()) {
            if (!(tree2 instanceof BlockTree)) continue;
            stmts.add(visitor.scan(tree2, context));
        }
    }

    public static boolean isMainMethod(MethodTree method) {
        VariableElement var;
        if (JavaNodes.isStatic(method) && "main".equals(method.getName().toString()) && method.getParameters().size() == 1 && (var = TreeUtils.elementFromDeclaration(method.getParameters().get(0))).asType() instanceof ArrayType) {
            TypeMirror componentType = ((ArrayType)var.asType()).getComponentType();
            return TypesUtils.isString(componentType);
        }
        return false;
    }

    private boolean hasMainMethod(ClassTree clazz) {
        for (Tree tree : clazz.getMembers()) {
            MethodTree method;
            if (!(tree instanceof MethodTree) || !ClassWriter.isMainMethod(method = (MethodTree)tree)) continue;
            return true;
        }
        return false;
    }

    private void addMainMethodCall(ClassTree clazz, List<JS> stmts, GenerationContext<JS> context) {
        if (!this.hasMainMethod(clazz)) {
            return;
        }
        TypeElement type = TreeUtils.elementFromDeclaration(clazz);
        Object target = context.getCurrentWrapper().isGlobal() ? null : (Object)context.js().name(context.getNames().getTypeName(context, type, DependencyType.STATIC));
        JavaScriptBuilder<JS> js = context.js();
        JS condition = js.unary(UnaryOperator.LOGICAL_COMPLEMENT, js.property(js.name("stjs"), "mainCallDisabled"));
        Object thenPart = js.expressionStatement(js.functionCall(js.property(target, "main"), Collections.emptyList()));
        stmts.add(js.ifStatement(condition, thenPart, null));
    }

    private JS getFieldTypeDesc(TypeMirror type, GenerationContext<JS> context) {
        JavaScriptBuilder<JS> js = context.js();
        if (JavaNodes.isJavaScriptPrimitive(type)) {
            return js.keyword(Keyword.NULL);
        }
        JS typeName = js.string(context.getNames().getTypeName(context, type, DependencyType.OTHER));
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            if (declaredType.asElement().getKind() == ElementKind.ENUM) {
                return js.object(Arrays.asList(NameValue.of("name", js.string("Enum")), NameValue.of("arguments", js.array(Collections.singleton(typeName)))));
            }
            if (!declaredType.getTypeArguments().isEmpty()) {
                ArrayList<JS> array = new ArrayList<JS>();
                for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                    array.add(this.getFieldTypeDesc(typeMirror, context));
                }
                return js.object(Arrays.asList(NameValue.of("name", typeName), NameValue.of("arguments", js.array(array))));
            }
        }
        return typeName;
    }

    private JS getTypeDescription(WriterVisitor<JS> visitor, ClassTree tree, GenerationContext<JS> context) {
        TypeElement type = TreeUtils.elementFromDeclaration(tree);
        ArrayList props = new ArrayList();
        for (Element element : ElementUtils.getAllFieldsIn(type)) {
            TypeMirror memberType = ElementUtils.getType(element);
            if (JavaNodes.isJavaScriptPrimitive(memberType) || element.getKind() == ElementKind.ENUM_CONSTANT || memberType instanceof TypeVariable || this.skipTypeDescForField(element)) continue;
            props.add(NameValue.of(element.getSimpleName(), this.getFieldTypeDesc(memberType, context)));
        }
        return context.js().object(props);
    }

    private boolean skipTypeDescForField(Element member) {
        if (((TypeElement)member.getEnclosingElement()).getQualifiedName().toString().startsWith("java.lang.")) {
            return true;
        }
        return member.getAnnotation(ServerSide.class) != null;
    }

    private String replaceFullNameWithConstructor(String typeName) {
        int pos = typeName.lastIndexOf(46);
        return "constructor" + typeName.substring(pos);
    }

    private JS writeAnnotationValue(WriterVisitor<JS> visitor, ExpressionTree expr, GenerationContext<JS> context) {
        if (expr instanceof NewArrayTree) {
            ArrayList items = new ArrayList();
            for (ExpressionTree expressionTree : ((NewArrayTree)expr).getInitializers()) {
                items.add(visitor.scan((Tree)expressionTree, context));
            }
            return context.js().array(items);
        }
        return (JS)visitor.scan((Tree)expr, context);
    }

    private JS getAnnotationForElement(AnnotationTree ann, WriterVisitor<JS> visitor, GenerationContext<JS> context) {
        if (AnnotationHelper.getRetentionType(ann.getAnnotationType()) == RetentionPolicy.SOURCE) {
            return null;
        }
        String annEntryKey = ann.getAnnotationType().toString();
        if (!context.getConfiguration().getAnnotations().contains(annEntryKey)) {
            return null;
        }
        ArrayList annotationArgsDesc = new ArrayList();
        for (ExpressionTree expressionTree : ann.getArguments()) {
            AssignmentTree assign = (AssignmentTree)expressionTree;
            annotationArgsDesc.add(NameValue.of(assign.getVariable().toString(), this.writeAnnotationValue(visitor, assign.getExpression(), context)));
        }
        return context.js().object(annotationArgsDesc);
    }

    private void addAnnotationsForElement(String name, List<NameValue<JS>> props, WriterVisitor<JS> visitor, List<? extends AnnotationTree> annotations, GenerationContext<JS> context) {
        if (annotations.isEmpty()) {
            return;
        }
        ArrayList annotationsDesc = new ArrayList();
        for (AnnotationTree annotationTree : annotations) {
            JS annotationArgs = this.getAnnotationForElement(annotationTree, visitor, context);
            if (annotationArgs == null) continue;
            String annEntryKey = annotationTree.getAnnotationType().toString();
            annotationsDesc.add(NameValue.of("\"" + annEntryKey + "\"", annotationArgs));
        }
        if (!annotationsDesc.isEmpty()) {
            props.add(NameValue.of(name, context.js().object(annotationsDesc)));
        }
    }

    private void addAnnotationsForMethod(MethodTree method, List<NameValue<JS>> props, WriterVisitor<JS> visitor, GenerationContext<JS> context) {
        String name = method.getName().toString();
        if ("<init>".equals(name)) {
            name = "_init_";
        }
        this.addAnnotationsForElement(name, props, visitor, method.getModifiers().getAnnotations(), context);
        for (int i = 0; i < method.getParameters().size(); ++i) {
            this.addAnnotationsForElement(method.getName().toString() + "$" + i, props, visitor, method.getParameters().get(i).getModifiers().getAnnotations(), context);
        }
    }

    private JS getAnnotationDescription(WriterVisitor<JS> visitor, ClassTree classTree, GenerationContext<JS> context) {
        ArrayList<NameValue<JS>> props = new ArrayList<NameValue<JS>>();
        this.addAnnotationsForElement("_", props, visitor, classTree.getModifiers().getAnnotations(), context);
        for (Tree tree : classTree.getMembers()) {
            if (MemberWriters.shouldSkip(context.getCurrentWrapper().child(tree))) continue;
            if (tree instanceof VariableTree) {
                VariableTree field = (VariableTree)tree;
                this.addAnnotationsForElement(field.getName().toString(), props, visitor, field.getModifiers().getAnnotations(), context);
                continue;
            }
            if (!(tree instanceof MethodTree)) continue;
            this.addAnnotationsForMethod((MethodTree)tree, props, visitor, context);
        }
        return context.js().object(props);
    }

    private boolean generareEnum(WriterVisitor<JS> visitor, ClassTree tree, GenerationContext<JS> context, List<JS> stmts) {
        TypeElement type = TreeUtils.elementFromDeclaration(tree);
        if (type.getKind() != ElementKind.ENUM) {
            return false;
        }
        JavaScriptBuilder<JS> js = context.js();
        ArrayList<JS> enumEntries = new ArrayList<JS>();
        for (Element element : ElementUtils.getAllFieldsIn(type)) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            enumEntries.add(js.string(element.getSimpleName().toString()));
        }
        JS enumConstructor = js.functionCall(js.property(js.name("stjs"), "enumeration"), enumEntries);
        String string = context.getNames().getTypeName(context, type, DependencyType.EXTENDS);
        if (string.contains(".")) {
            boolean innerClass = type.getEnclosingElement().getKind() != ElementKind.PACKAGE;
            String leftSide = innerClass ? this.replaceFullNameWithConstructor(string) : string;
            stmts.add(js.expressionStatement(js.assignment(AssignOperator.ASSIGN, js.name(leftSide), enumConstructor)));
        } else {
            stmts.add(js.variableDeclaration(true, Collections.singleton(NameValue.of(string, enumConstructor))));
        }
        return true;
    }

    private boolean generateGlobal(WriterVisitor<JS> visitor, ClassTree tree, GenerationContext<JS> context, List<JS> stmts) {
        if (!context.getCurrentWrapper().isGlobal()) {
            return false;
        }
        List<Tree> nonConstructors = this.getAllMembersExceptConstructors(tree);
        for (Tree member : nonConstructors) {
            stmts.add(visitor.scan(member, context));
        }
        this.addStaticInitializers(visitor, tree, context, stmts);
        this.addMainMethodCall(tree, stmts, context);
        return true;
    }

    private void addConstructorStatement(WriterVisitor<JS> visitor, ClassTree tree, GenerationContext<JS> context, List<JS> stmts) {
        boolean anonymousClass;
        boolean bl = anonymousClass = tree.getSimpleName().length() == 0;
        if (anonymousClass) {
            return;
        }
        JavaScriptBuilder<JS> js = context.js();
        TypeElement type = TreeUtils.elementFromDeclaration(tree);
        String typeName = context.getNames().getTypeName(context, type, DependencyType.EXTENDS);
        if (typeName.contains(".")) {
            stmts.add(js.expressionStatement(js.assignment(AssignOperator.ASSIGN, this.getClassName(tree, context), this.getConstructor(visitor, tree, context))));
        } else {
            stmts.add(js.variableDeclaration(true, typeName, this.getConstructor(visitor, tree, context)));
        }
    }

    public JS getClassName(ClassTree tree, GenerationContext<JS> context) {
        TypeElement type = TreeUtils.elementFromDeclaration(tree);
        String typeName = context.getNames().getTypeName(context, type, DependencyType.EXTENDS);
        if (typeName.contains(".") && type.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            return context.js().name(this.replaceFullNameWithConstructor(typeName));
        }
        return context.js().name(typeName);
    }

    @Override
    public JS visit(WriterVisitor<JS> visitor, ClassTree tree, GenerationContext<JS> context) {
        boolean anonymousClass;
        if (this.isBridge(tree)) {
            return null;
        }
        JavaScriptBuilder<JS> js = context.js();
        ArrayList<Object> stmts = new ArrayList<Object>();
        if (this.generateGlobal(visitor, tree, context, stmts)) {
            return js.statements(stmts);
        }
        this.addNamespace(tree, context, stmts);
        if (this.generareEnum(visitor, tree, context, stmts)) {
            return js.statements(stmts);
        }
        JS name = this.getClassName(tree, context);
        JS superClazz = this.getSuperClass(tree, context);
        JS interfaces = this.getInterfaces(tree, context);
        JS members = this.getMembers(visitor, tree, context);
        JS typeDesc = this.getTypeDescription(visitor, tree, context);
        JS annotationDesc = this.getAnnotationDescription(visitor, tree, context);
        boolean bl = anonymousClass = tree.getSimpleName().length() == 0;
        if (anonymousClass) {
            name = this.getConstructor(visitor, tree, context);
        }
        this.addConstructorStatement(visitor, tree, context, stmts);
        Object extendsCall = js.functionCall(js.property(js.name("stjs"), "extend"), Arrays.asList(name, superClazz, interfaces, members, typeDesc, annotationDesc));
        if (anonymousClass) {
            stmts.add(extendsCall);
        } else {
            stmts.add(context.withPosition(tree, js.expressionStatement(js.assignment(AssignOperator.ASSIGN, name, extendsCall))));
        }
        this.addStaticInitializers(visitor, tree, context, stmts);
        this.addMainMethodCall(tree, stmts, context);
        return js.statements(stmts);
    }

    private boolean isBridge(ClassTree tree) {
        TypeElement type = TreeUtils.elementFromDeclaration(tree);
        List<? extends AnnotationMirror> annotations = type.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            if (!annotationMirror.getAnnotationType().toString().equals(STJSBridge.class.getName())) continue;
            return true;
        }
        return false;
    }
}

