/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.expression;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import javax.lang.model.type.TypeMirror;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.javac.TypesUtils;
import org.stjs.generator.javascript.BinaryOperator;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;

public class BinaryWriter<JS>
implements WriterContributor<BinaryTree, JS> {
    @Override
    public JS visit(WriterVisitor<JS> visitor, BinaryTree tree, GenerationContext<JS> context) {
        boolean integerDivision;
        Object left = visitor.scan((Tree)tree.getLeftOperand(), context);
        Object right = visitor.scan((Tree)tree.getRightOperand(), context);
        BinaryOperator op = BinaryOperator.valueOf(tree.getKind());
        assert (op != null) : "Unknow operator:" + (Object)((Object)tree.getKind());
        Object expr = context.js().binary(op, Arrays.asList(left, right));
        TypeMirror leftType = context.getTrees().getTypeMirror(new TreePath(context.getCurrentPath(), tree.getLeftOperand()));
        TypeMirror rightType = context.getTrees().getTypeMirror(new TreePath(context.getCurrentPath(), tree.getRightOperand()));
        boolean bl = integerDivision = tree.getKind() == Tree.Kind.DIVIDE && TypesUtils.isIntegral(leftType) && TypesUtils.isIntegral(rightType);
        if (integerDivision) {
            JS target = context.js().property(context.js().name("stjs"), "trunc");
            return (JS)context.js().functionCall(target, Collections.singleton(expr));
        }
        return (JS)expr;
    }
}

