/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.expression;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.javascript.Keyword;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;

public class LiteralWriter<JS>
implements WriterContributor<LiteralTree, JS> {
    @Override
    public JS visit(WriterVisitor<JS> visitor, LiteralTree tree, GenerationContext<JS> context) {
        if (tree.getKind() == Tree.Kind.STRING_LITERAL || tree.getKind() == Tree.Kind.CHAR_LITERAL) {
            return tree.getKind() == Tree.Kind.STRING_LITERAL ? context.js().string(tree.getValue().toString()) : context.js().character(tree.getValue().toString());
        }
        if (tree.getKind() == Tree.Kind.NULL_LITERAL) {
            return context.js().keyword(Keyword.NULL);
        }
        if (tree.getKind() == Tree.Kind.BOOLEAN_LITERAL) {
            return context.js().keyword(Boolean.TRUE.equals(tree.getValue()) ? Keyword.TRUE : Keyword.FALSE);
        }
        return context.js().number((Number)tree.getValue());
    }
}

