/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.expression;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.javac.ElementUtils;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.visitor.DiscriminatorKey;
import org.stjs.generator.writer.MemberWriters;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;

public class MethodInvocationWriter<JS>
implements WriterContributor<MethodInvocationTree, JS> {
    public static <JS, T extends MethodInvocationTree> JS buildTarget(WriterVisitor<JS> visitor, TreeWrapper<T, JS> tw) {
        ExpressionTree select = ((MethodInvocationTree)tw.getTree()).getMethodSelect();
        if (select instanceof IdentifierTree) {
            return MemberWriters.buildTarget(tw);
        }
        if (TreeUtils.isSuperCall((MethodInvocationTree)tw.getTree())) {
            return MemberWriters.buildTarget(tw);
        }
        MemberSelectTree memberSelect = (MemberSelectTree)select;
        Object targetJS = visitor.scan((Tree)memberSelect.getExpression(), tw.getContext());
        if (tw.isStatic() && !ElementUtils.isTypeKind(tw.child(memberSelect).child(memberSelect.getExpression()).getElement())) {
            targetJS = tw.getContext().js().property(targetJS, "constructor");
        }
        return (JS)targetJS;
    }

    public static String buildMethodName(MethodInvocationTree tree) {
        ExpressionTree select = tree.getMethodSelect();
        if (select instanceof IdentifierTree) {
            return ((IdentifierTree)select).getName().toString();
        }
        MemberSelectTree memberSelect = (MemberSelectTree)select;
        return memberSelect.getIdentifier().toString();
    }

    public static <JS> List<JS> buildArguments(WriterVisitor<JS> visitor, MethodInvocationTree tree, GenerationContext<JS> context) {
        ArrayList arguments = new ArrayList();
        for (Tree tree2 : tree.getArguments()) {
            arguments.add(visitor.scan(tree2, context));
        }
        return arguments;
    }

    public static <JS> String buildTemplateName(MethodInvocationTree tree, GenerationContext<JS> context) {
        String name = context.getCurrentWrapper().getMethodTemplate();
        if (name != null) {
            return name;
        }
        return context.getCurrentWrapper().getEnclosingType().isJavaScriptFunction() ? "invoke" : "none";
    }

    @Override
    public JS visit(WriterVisitor<JS> visitor, MethodInvocationTree tree, GenerationContext<JS> context) {
        String templateName = MethodInvocationWriter.buildTemplateName(tree, context);
        return (JS)visitor.forward(DiscriminatorKey.of(MethodInvocationWriter.class.getSimpleName(), templateName), tree, context);
    }
}

