/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.templates;

import com.sun.source.tree.MethodInvocationTree;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javascript.Keyword;
import org.stjs.generator.name.DependencyType;
import org.stjs.generator.utils.JavaNodes;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;
import org.stjs.generator.writer.expression.MethodInvocationWriter;

public class DefaultTemplate<JS>
implements WriterContributor<MethodInvocationTree, JS> {
    private boolean isCallToSuperConstructor(MethodInvocationTree tree) {
        if (!TreeUtils.isSuperCall(tree)) {
            return false;
        }
        ExecutableElement methodElement = TreeUtils.elementFromUse(tree);
        return !JavaNodes.isStatic(methodElement);
    }

    private JS callToSuperConstructor(WriterVisitor<JS> visitor, MethodInvocationTree tree, GenerationContext<JS> context) {
        ExecutableElement methodElement = TreeUtils.elementFromUse(tree);
        TypeElement typeElement = (TypeElement)methodElement.getEnclosingElement();
        String methodName = MethodInvocationWriter.buildMethodName(tree);
        if ("super".equals(methodName) && JavaNodes.sameRawType(typeElement.asType(), Object.class)) {
            return null;
        }
        if ("super".equals(methodName) && context.getCurrentWrapper().getEnclosingType().isSyntheticType()) {
            return null;
        }
        String typeName = context.getNames().getTypeName(context, typeElement, DependencyType.STATIC);
        JS superType = context.js().name("super".equals(methodName) ? typeName : typeName + ".prototype." + methodName);
        List<JS> arguments = MethodInvocationWriter.buildArguments(visitor, tree, context);
        arguments.add(0, context.js().keyword(Keyword.THIS));
        return context.js().functionCall(context.js().property(superType, "call"), arguments);
    }

    @Override
    public JS visit(WriterVisitor<JS> visitor, MethodInvocationTree tree, GenerationContext<JS> context) {
        if (this.isCallToSuperConstructor(tree)) {
            return this.callToSuperConstructor(visitor, tree, context);
        }
        JS target = MethodInvocationWriter.buildTarget(visitor, context.getCurrentWrapper());
        String name = MethodInvocationWriter.buildMethodName(tree);
        List<JS> arguments = MethodInvocationWriter.buildArguments(visitor, tree, context);
        return context.js().functionCall(context.js().property(target, name), arguments);
    }
}

