/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.templates.fields;

import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import javax.lang.model.type.TypeMirror;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.javac.TypesUtils;
import org.stjs.generator.javascript.AssignOperator;
import org.stjs.generator.javascript.BinaryOperator;
import org.stjs.generator.javascript.JavaScriptBuilder;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;

public class DefaultCompoundAssignmentTemplate<JS>
implements WriterContributor<CompoundAssignmentTree, JS> {
    public static <JS> JS rightSide(JS left, JS right, CompoundAssignmentTree tree, GenerationContext<JS> context) {
        boolean integerDivision;
        TypeMirror leftType = context.getTrees().getTypeMirror(new TreePath(context.getCurrentPath(), tree.getVariable()));
        TypeMirror rightType = context.getTrees().getTypeMirror(new TreePath(context.getCurrentPath(), tree.getExpression()));
        JavaScriptBuilder<JS> js = context.js();
        boolean bl = integerDivision = tree.getKind() == Tree.Kind.DIVIDE_ASSIGNMENT && TypesUtils.isIntegral(leftType) && TypesUtils.isIntegral(rightType);
        if (integerDivision) {
            JS target = js.property(js.name("stjs"), "trunc");
            Object expr = js.binary(BinaryOperator.DIVIDE, Arrays.asList(left, js.paren(right)));
            return (JS)js.functionCall(target, Collections.singleton(expr));
        }
        return right;
    }

    public static <JS> AssignOperator getAssignOperator(CompoundAssignmentTree tree, GenerationContext<JS> context) {
        TypeMirror leftType = context.getTrees().getTypeMirror(new TreePath(context.getCurrentPath(), tree.getVariable()));
        TypeMirror rightType = context.getTrees().getTypeMirror(new TreePath(context.getCurrentPath(), tree.getExpression()));
        boolean integerDivision = tree.getKind() == Tree.Kind.DIVIDE_ASSIGNMENT && TypesUtils.isIntegral(leftType) && TypesUtils.isIntegral(rightType);
        return integerDivision ? AssignOperator.ASSIGN : AssignOperator.valueOf(tree.getKind());
    }

    @Override
    public JS visit(WriterVisitor<JS> visitor, CompoundAssignmentTree tree, GenerationContext<JS> context) {
        Object left = visitor.scan((Tree)tree.getVariable(), context);
        Object right = visitor.scan((Tree)tree.getExpression(), context);
        return context.js().assignment(DefaultCompoundAssignmentTemplate.getAssignOperator(tree, context), left, DefaultCompoundAssignmentTemplate.rightSide(left, right, tree, context));
    }
}

