/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.templates.fields;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.util.ArrayList;
import java.util.Arrays;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.javascript.BinaryOperator;
import org.stjs.generator.javascript.Keyword;
import org.stjs.generator.javascript.UnaryOperator;
import org.stjs.generator.writer.WriterVisitor;
import org.stjs.generator.writer.templates.fields.DefaultUnaryTemplate;
import org.stjs.generator.writer.templates.fields.SetterAssignmentTemplate;

public class SetterUnaryTemplate<JS>
extends DefaultUnaryTemplate<JS> {
    @Override
    public JS visit(WriterVisitor<JS> visitor, UnaryTree tree, GenerationContext<JS> context) {
        return this.doVisit(visitor, tree, context, false);
    }

    protected BinaryOperator getBinaryOperator(UnaryOperator op) {
        if (op == UnaryOperator.PREFIX_DECREMENT || op == UnaryOperator.POSTFIX_DECREMENT) {
            return BinaryOperator.MINUS;
        }
        if (op == UnaryOperator.PREFIX_INCREMENT || op == UnaryOperator.POSTFIX_INCREMENT) {
            return BinaryOperator.PLUS;
        }
        return null;
    }

    protected JS doVisit(WriterVisitor<JS> visitor, UnaryTree tree, GenerationContext<JS> context, boolean global) {
        UnaryOperator op = UnaryOperator.valueOf(tree.getKind());
        assert (op != null) : "Unknow operator:" + (Object)((Object)tree.getKind());
        BinaryOperator binaryOp = this.getBinaryOperator(op);
        if (binaryOp == null) {
            return super.visit(visitor, tree, context);
        }
        Object operand = visitor.scan((Tree)tree.getExpression(), context);
        TreeWrapper<ExpressionTree, JS> twOperand = context.getCurrentWrapper().child(tree.getExpression());
        JS target = SetterAssignmentTemplate.getTarget(visitor, twOperand, context);
        JS field = SetterAssignmentTemplate.getField(twOperand, context);
        Object value = context.js().binary(binaryOp, Arrays.asList(operand, context.js().number(1)));
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add(field);
        arguments.add(value);
        if (op.isPostfix()) {
            arguments.add(context.js().keyword(Keyword.TRUE));
        }
        if (global) {
            arguments.add(0, target);
            return context.js().functionCall(context.js().property(context.js().name("stjs"), "setField"), arguments);
        }
        return context.js().functionCall(context.js().property(target, "set"), arguments);
    }
}

