/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.command;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.server.Session;
import org.subethamail.smtp.server.io.CharTerminatedInputStream;
import org.subethamail.smtp.server.io.DotUnstuffingInputStream;

public class DataCommand
extends BaseCommand {
    private static final char[] SMTP_TERMINATOR = new char[]{'\r', '\n', '.', '\r', '\n'};

    public DataCommand() {
        super("DATA", "Following text is collected as the message.\nEnd data with <CR><LF>.<CR><LF>");
    }

    public void execute(String commandString, ConnectionContext context) throws IOException {
        Session session = context.getSession();
        if (!session.getHasSender()) {
            context.sendResponse("503 Error: need MAIL command");
            return;
        }
        if (session.getRecipientCount() == 0) {
            context.sendResponse("503 Error: need RCPT command");
            return;
        }
        context.sendResponse("354 End data with <CR><LF>.<CR><LF>");
        session.setDataMode(true);
        InputStream stream = context.getConnection().getInput();
        stream = new BufferedInputStream(stream);
        stream = new CharTerminatedInputStream(stream, SMTP_TERMINATOR);
        stream = new DotUnstuffingInputStream(stream);
        try {
            session.getMessageHandler().data(stream);
            context.sendResponse("250 Ok");
        }
        catch (RejectException ex) {
            context.sendResponse(ex.getMessage());
        }
        session.reset(true);
    }
}

