/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl;

import java.util.ArrayList;
import org.tinygroup.tinysqldsl.Select;
import org.tinygroup.tinysqldsl.Statement;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.operator.SetOperationInstanceCallBack;
import org.tinygroup.tinysqldsl.select.OrderByElement;
import org.tinygroup.tinysqldsl.select.PlainSelect;
import org.tinygroup.tinysqldsl.select.SetOperation;
import org.tinygroup.tinysqldsl.select.SetOperationList;
import org.tinygroup.tinysqldsl.select.UnionOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexSelect<T extends ComplexSelect<T>>
extends StatementSqlBuilder
implements Statement {
    protected SetOperationList operationList = new SetOperationList();
    private String id;

    public String getId() {
        return this.id;
    }

    protected ComplexSelect() {
    }

    public static ComplexSelect union(Select ... selects) {
        return ComplexSelect.setOperation(new SetOperationInstanceCallBack(){

            public SetOperation instanceOperation() {
                return new UnionOperation();
            }
        }, selects);
    }

    public static ComplexSelect unionAll(Select ... selects) {
        return ComplexSelect.setOperation(new SetOperationInstanceCallBack(){

            public SetOperation instanceOperation() {
                return new UnionOperation(true);
            }
        }, selects);
    }

    public static ComplexSelect setOperation(SetOperationInstanceCallBack instance, Select ... selects) {
        ComplexSelect complexSelect = new ComplexSelect();
        ArrayList<PlainSelect> plainSelects = new ArrayList<PlainSelect>();
        ArrayList<SetOperation> operations = new ArrayList<SetOperation>();
        for (int i = 0; i < selects.length; ++i) {
            Select select = selects[0];
            plainSelects.add(select.getPlainSelect());
            if (i == 0) continue;
            operations.add(instance.instanceOperation());
        }
        complexSelect.operationList.setOpsAndSelects(plainSelects, operations);
        return complexSelect;
    }

    public T orderBy(OrderByElement ... orderByElements) {
        this.operationList.addOrderByElements(orderByElements);
        return (T)this;
    }

    public SetOperationList getOperationList() {
        return this.operationList;
    }

    public String toString() {
        return this.sql();
    }

    @Override
    protected void parserStatementBody() {
        this.build(this.operationList);
    }

    @Override
    public void id(String id) {
        this.id = id;
    }
}

