/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.expression.conditional.AndExpression;
import org.tinygroup.tinysqldsl.expression.conditional.OrExpression;

public class Condition
implements Expression {
    private Expression expression;
    private List<Object> extendParams = new ArrayList<Object>();

    public Condition(Expression expression, Object ... values) {
        this.expression = expression;
        Collections.addAll(this.extendParams, values);
    }

    public Condition and(Condition condition) {
        this.expression = new AndExpression(this.getExpression(), condition.getExpression());
        Collections.addAll(this.extendParams, condition.getValues());
        return this;
    }

    public Condition or(Condition condition) {
        this.expression = new OrExpression(this.getExpression(), condition.getExpression());
        Collections.addAll(this.extendParams, condition.getValues());
        return this;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Object[] getValues() {
        return this.extendParams.toArray();
    }

    public String toString() {
        return this.expression.toString();
    }

    public void builderExpression(StatementSqlBuilder builder) {
        Expression expression = this.getExpression();
        expression.builderExpression(builder);
        builder.addParamValue(this.extendParams.toArray());
    }
}

