/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.tinygroup.tinysqldsl.base.Column;
import org.tinygroup.tinysqldsl.base.SelectBody;
import org.tinygroup.tinysqldsl.base.Table;
import org.tinygroup.tinysqldsl.base.Value;
import org.tinygroup.tinysqldsl.expression.relational.ExpressionList;
import org.tinygroup.tinysqldsl.insert.InsertBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertContext {
    private Map<String, Object> params = new CaseInsensitiveMap();
    private List<Object> paramValues = new ArrayList<Object>();
    private List<String> columnNames = new ArrayList<String>();
    private List<Column> columns = new ArrayList<Column>();
    private ExpressionList itemsList = new ExpressionList();
    private SelectBody selectBody;
    private Table table;
    private String schema;
    private String tableName;
    private boolean useValues = true;
    private List<Value> values = new ArrayList<Value>();

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public void addValues(Value ... values) {
        for (Value value : values) {
            Column column = value.getColumn();
            this.columns.add(column);
            this.addColumnName(column.getColumnName());
            this.putParam(column.getColumnName(), value.getValue());
            this.itemsList.addExpression(value.getExpression());
            this.values.add(value);
        }
    }

    public Object[] getParamValues() {
        return this.paramValues.toArray();
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    private void putParam(String columnName, Object value) {
        this.params.put(columnName, value);
        this.paramValues.add(value);
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    private void addColumnName(String columnName) {
        this.columnNames.add(columnName);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setSelectBody(SelectBody selectBody) {
        this.selectBody = selectBody;
    }

    public boolean existParam(String columnName) {
        return this.params.containsKey(columnName);
    }

    public Object getParamValue(String columnName) {
        return this.params.get(columnName);
    }

    public InsertContext copyContext() {
        InsertContext context = new InsertContext();
        context.setSchema(this.schema);
        context.setTable(this.table);
        context.setTableName(this.tableName);
        context.setUseValues(true);
        context.addValues(this.values.toArray(new Value[0]));
        return context;
    }

    public InsertBody createInsert() {
        InsertBody insertBody = new InsertBody();
        insertBody.setTable(this.table);
        insertBody.setColumns(this.columns);
        if (this.useValues) {
            insertBody.setItemsList(this.itemsList);
        } else {
            insertBody.setSelectBody(this.selectBody);
        }
        return insertBody;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public void setItemsList(ExpressionList itemsList) {
        this.itemsList = itemsList;
    }
}

