/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.base;

import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.tinygroup.commons.beanutil.BeanUtil;
import org.tinygroup.tinysqldsl.KeyGenerator;
import org.tinygroup.tinysqldsl.base.Alias;
import org.tinygroup.tinysqldsl.base.MultiPartName;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.formitem.FromItem;
import org.tinygroup.tinysqldsl.selectitem.AllTableColumns;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
implements FromItem,
MultiPartName {
    public final AllTableColumns ALL = new AllTableColumns(this);
    private String schemaName;
    private String name;
    private Alias alias;
    private Map<String, KeyGenerator> generatorMap = new CaseInsensitiveMap();
    private Class pojoType;

    public Table() {
    }

    public <T extends Table> T as(String aliasName) {
        return this.as(aliasName, false);
    }

    public <T extends Table> T as(String aliasName, boolean withAs) {
        try {
            Table table = (Table)BeanUtil.deepCopy((Object)this);
            table.setAlias(new Alias(aliasName, withAs));
            return (T)table;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Table(String name) {
        this.name = name;
    }

    public Table(String schemaName, String name) {
        this(name);
        this.schemaName = schemaName;
    }

    public Table(String schemaName, String name, String alias) {
        this(schemaName, name);
        this.alias = new Alias(alias);
    }

    public Table(String schemaName, String name, String alias, boolean withAs) {
        this(schemaName, name);
        this.alias = new Alias(alias, withAs);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    @Override
    public String getFullyQualifiedName() {
        String fqn = "";
        if (this.schemaName != null) {
            fqn = fqn + this.schemaName;
        }
        if (fqn != null && fqn.length() != 0) {
            fqn = fqn + ".";
        }
        if (this.name != null) {
            fqn = fqn + this.name;
        }
        return fqn;
    }

    public String getReferenceName() {
        if (this.alias != null) {
            return this.alias.getName();
        }
        return this.getFullyQualifiedName();
    }

    public String toString() {
        return this.getFullyQualifiedName() + (this.alias != null ? this.alias.toString() : "");
    }

    @Override
    public void builderFromItem(StatementSqlBuilder builder) {
        StringBuilder buffer = builder.getStringBuilder();
        buffer.append(this.getFullyQualifiedName());
        Alias alias = this.getAlias();
        if (alias != null) {
            buffer.append(alias);
        }
    }

    public Map<String, KeyGenerator> getGeneratorMap() {
        return this.generatorMap;
    }

    public Class getPojoType() {
        return this.pojoType;
    }
}

