/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.expression;

import org.tinygroup.tinysqldsl.base.Column;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.expression.relational.ExpressionList;
import org.tinygroup.tinysqldsl.operator.SimpleBinaryOperator;
import org.tinygroup.tinysqldsl.selectitem.SelectItem;

public class Function
extends SimpleBinaryOperator
implements Expression,
SelectItem {
    private String name;
    private ExpressionList parameters;
    private boolean allColumns = false;
    private boolean distinct = false;
    private boolean isEscaped = false;

    public Function() {
    }

    public Function(String name, boolean allColumns) {
        this.name = name;
        this.allColumns = allColumns;
    }

    public Function(String name, ExpressionList parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    public Function(String name, ExpressionList parameters, boolean allColumns, boolean distinct, boolean isEscaped) {
        this.name = name;
        this.parameters = parameters;
        this.allColumns = allColumns;
        this.distinct = distinct;
        this.isEscaped = isEscaped;
    }

    public static Function sum() {
        return new Function("sum", true);
    }

    public static Function count() {
        return new Function("count", true);
    }

    public static Function avg() {
        return new Function("avg", true);
    }

    public static Function max() {
        return new Function("max", true);
    }

    public static Function min() {
        return new Function("min", true);
    }

    public Function sum(String columnName) {
        return new Function("sum", ExpressionList.expressionList(new Column(columnName)));
    }

    public Function count(String columnName) {
        return new Function("count", ExpressionList.expressionList(new Column(columnName)));
    }

    public Function avg(String columnName) {
        return new Function("avg", ExpressionList.expressionList(new Column(columnName)));
    }

    public Function max(String columnName) {
        return new Function("max", ExpressionList.expressionList(new Column(columnName)));
    }

    public Function min(String columnName) {
        return new Function("min", ExpressionList.expressionList(new Column(columnName)));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean b) {
        this.allColumns = b;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public ExpressionList getParameters() {
        return this.parameters;
    }

    public void setParameters(ExpressionList list) {
        this.parameters = list;
    }

    public boolean isEscaped() {
        return this.isEscaped;
    }

    public void setEscaped(boolean isEscaped) {
        this.isEscaped = isEscaped;
    }

    public String toString() {
        String params;
        if (this.parameters != null) {
            params = this.parameters.toString();
            if (this.isDistinct()) {
                params = params.replaceFirst("\\(", "(DISTINCT ");
            } else if (this.isAllColumns()) {
                params = params.replaceFirst("\\(", "(ALL ");
            }
        } else {
            params = this.isAllColumns() ? "(*)" : "()";
        }
        String ans = this.name + "" + params + "";
        if (this.isEscaped) {
            ans = "{fn " + ans + "}";
        }
        return ans;
    }

    public void builderExpression(StatementSqlBuilder builder) {
        this.internalBuilder(builder);
    }

    private void internalBuilder(StatementSqlBuilder builder) {
        StringBuilder buffer = builder.getStringBuilder();
        if (this.isEscaped()) {
            buffer.append("{fn ");
        }
        buffer.append(this.name);
        if (this.isAllColumns() && this.getParameters() == null) {
            buffer.append("(*)");
        } else if (this.getParameters() == null) {
            buffer.append("()");
        } else {
            boolean oldUseBracketsInExprList = builder.isUseBracketsInExprList();
            if (this.isDistinct()) {
                buffer.append("(DISTINCT ");
                builder.setUseBracketsInExprList(false);
            } else if (this.isAllColumns()) {
                buffer.append("(ALL ");
                builder.setUseBracketsInExprList(false);
            }
            this.getParameters().builderItemList(builder);
            builder.setUseBracketsInExprList(oldUseBracketsInExprList);
            if (this.isDistinct() || this.isAllColumns()) {
                buffer.append(")");
            }
        }
        if (this.isEscaped()) {
            buffer.append("}");
        }
    }

    public void builderSelectItem(StatementSqlBuilder builder) {
        this.internalBuilder(builder);
    }
}

