/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.expression.conditional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.expression.relational.ExpressionList;
import org.tinygroup.tinysqldsl.util.DslUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionExpressionList
implements Expression {
    private List<Expression> expressions;
    private String comma = ",";
    private boolean useBrackets = true;
    private boolean useComma = true;

    public ConditionExpressionList() {
        this.expressions = new ArrayList<Expression>();
    }

    public ConditionExpressionList(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public String getComma() {
        return this.comma;
    }

    public void setComma(String comma) {
        this.comma = comma;
    }

    public boolean isUseBrackets() {
        return this.useBrackets;
    }

    public void setUseBrackets(boolean useBrackets) {
        this.useBrackets = useBrackets;
    }

    public boolean isUseComma() {
        return this.useComma;
    }

    public void setUseComma(boolean useComma) {
        this.useComma = useComma;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public void addExpression(Expression expression) {
        if (this.expressions == null) {
            this.expressions = new ArrayList<Expression>();
        }
        this.expressions.add(expression);
    }

    public static ExpressionList expressionList(Expression expr) {
        return new ExpressionList(Collections.singletonList(expr));
    }

    public String toString() {
        return DslUtil.getStringList(this.expressions, this.useComma, this.useBrackets, this.comma);
    }

    @Override
    public void builderExpression(StatementSqlBuilder builder) {
        builder.appendSql(this.toString());
    }
}

