/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.expression.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.expression.relational.ItemsList;
import org.tinygroup.tinysqldsl.util.DslUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionList
implements ItemsList {
    private List<Expression> expressions;
    private String comma = ",";
    private boolean useBrackets = true;
    private boolean useComma = true;

    public ExpressionList() {
        this.expressions = new ArrayList<Expression>();
    }

    public ExpressionList(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public String getComma() {
        return this.comma;
    }

    public void setComma(String comma) {
        this.comma = comma;
    }

    public boolean isUseBrackets() {
        return this.useBrackets;
    }

    public void setUseBrackets(boolean useBrackets) {
        this.useBrackets = useBrackets;
    }

    public boolean isUseComma() {
        return this.useComma;
    }

    public void setUseComma(boolean useComma) {
        this.useComma = useComma;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public void addExpression(Expression expression) {
        if (this.expressions == null) {
            this.expressions = new ArrayList<Expression>();
        }
        this.expressions.add(expression);
    }

    public static ExpressionList expressionList(Expression expr) {
        return new ExpressionList(Collections.singletonList(expr));
    }

    public String toString() {
        return DslUtil.getStringList(this.expressions, this.useComma, this.useBrackets, this.comma);
    }

    @Override
    public void builderItemList(StatementSqlBuilder builder) {
        boolean useBracketsInExprList = builder.isUseBracketsInExprList();
        StringBuilder buffer = builder.getStringBuilder();
        if (useBracketsInExprList) {
            buffer.append("(");
        }
        Iterator<Expression> iter = this.getExpressions().iterator();
        while (iter.hasNext()) {
            Expression expression = iter.next();
            expression.builderExpression(builder);
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        if (useBracketsInExprList) {
            buffer.append(")");
        }
    }
}

