/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.expression.relational;

import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.expression.relational.ItemsList;
import org.tinygroup.tinysqldsl.expression.relational.SupportsOldOracleJoinSyntax;

public class InExpression
implements Expression,
SupportsOldOracleJoinSyntax {
    private Expression leftExpression;
    private ItemsList leftItemsList;
    private ItemsList rightItemsList;
    private boolean not = false;
    private int oldOracleJoinSyntax = 0;

    public InExpression(Expression leftExpression, ItemsList rightItemsList) {
        this(leftExpression, rightItemsList, false);
    }

    public InExpression(Expression leftExpression, ItemsList rightItemsList, boolean not) {
        this.leftExpression = leftExpression;
        this.rightItemsList = rightItemsList;
        this.not = not;
    }

    public InExpression(ItemsList leftItemsList, ItemsList rightItemsList) {
        this(leftItemsList, rightItemsList, false);
    }

    public InExpression(ItemsList leftItemsList, ItemsList rightItemsList, boolean not) {
        this.leftItemsList = leftItemsList;
        this.rightItemsList = rightItemsList;
        this.not = not;
    }

    public void setOldOracleJoinSyntax(int oldOracleJoinSyntax) {
        this.oldOracleJoinSyntax = oldOracleJoinSyntax;
        if (oldOracleJoinSyntax < 0 || oldOracleJoinSyntax > 1) {
            throw new IllegalArgumentException("unexpected join type for oracle found with IN (type=" + oldOracleJoinSyntax + ")");
        }
    }

    public int getOldOracleJoinSyntax() {
        return this.oldOracleJoinSyntax;
    }

    public ItemsList getRightItemsList() {
        return this.rightItemsList;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public boolean isNot() {
        return this.not;
    }

    public void setLeftExpression(Expression leftExpression) {
        this.leftExpression = leftExpression;
    }

    public void setLeftItemsList(ItemsList leftItemsList) {
        this.leftItemsList = leftItemsList;
    }

    public void setRightItemsList(ItemsList rightItemsList) {
        this.rightItemsList = rightItemsList;
    }

    public void setNot(boolean not) {
        this.not = not;
    }

    public ItemsList getLeftItemsList() {
        return this.leftItemsList;
    }

    private String getLeftExpressionString() {
        return this.leftExpression + (this.oldOracleJoinSyntax == 1 ? "(+)" : "");
    }

    public String toString() {
        return (this.leftExpression == null ? this.leftItemsList : this.getLeftExpressionString()) + " " + (this.not ? "NOT " : "") + "IN " + this.rightItemsList + "";
    }

    public int getOraclePriorPosition() {
        return 0;
    }

    public void setOraclePriorPosition(int priorPosition) {
        if (priorPosition != 0) {
            throw new IllegalArgumentException("unexpected prior for oracle found");
        }
    }

    public void builderExpression(StatementSqlBuilder builder) {
        StringBuilder buffer = builder.getStringBuilder();
        if (this.getLeftExpression() == null) {
            this.getLeftItemsList().builderItemList(builder);
        } else {
            this.getLeftExpression().builderExpression(builder);
            if (this.getOldOracleJoinSyntax() == 1) {
                buffer.append("(+)");
            }
        }
        if (this.isNot()) {
            buffer.append(" NOT");
        }
        buffer.append(" IN ");
        this.getRightItemsList().builderItemList(builder);
    }
}

