/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.expression.relational;

import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.expression.BinaryExpression;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.expression.relational.RegExpMatchOperatorType;

public class RegExpMatchOperator
extends BinaryExpression {
    private RegExpMatchOperatorType operatorType;

    public RegExpMatchOperator(Expression leftExpression, Expression rightExpression, boolean not, RegExpMatchOperatorType operatorType) {
        super(leftExpression, rightExpression, not);
        if (operatorType == null) {
            throw new NullPointerException();
        }
        this.operatorType = operatorType;
    }

    public RegExpMatchOperatorType getOperatorType() {
        return this.operatorType;
    }

    public String getStringExpression() {
        switch (this.operatorType) {
            case MATCH_CASESENSITIVE: {
                return "~";
            }
            case MATCH_CASEINSENSITIVE: {
                return "~*";
            }
            case NOT_MATCH_CASESENSITIVE: {
                return "!~";
            }
            case NOT_MATCH_CASEINSENSITIVE: {
                return "!~*";
            }
        }
        return null;
    }

    public void builderExpression(StatementSqlBuilder builder) {
        builder.visitBinaryExpression(this, " " + this.getStringExpression() + " ");
    }
}

