/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.extend;

import java.util.ArrayList;
import org.tinygroup.tinysqldsl.ComplexSelect;
import org.tinygroup.tinysqldsl.Select;
import org.tinygroup.tinysqldsl.operator.SetOperationInstanceCallBack;
import org.tinygroup.tinysqldsl.select.IntersectOperation;
import org.tinygroup.tinysqldsl.select.MinusOperation;
import org.tinygroup.tinysqldsl.select.PlainSelect;
import org.tinygroup.tinysqldsl.select.SetOperation;
import org.tinygroup.tinysqldsl.select.UnionOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleComplexSelect
extends ComplexSelect<OracleComplexSelect> {
    private OracleComplexSelect() {
    }

    public static OracleComplexSelect union(Select ... selects) {
        return OracleComplexSelect.setOperation(new SetOperationInstanceCallBack(){

            public SetOperation instanceOperation() {
                return new UnionOperation();
            }
        }, selects);
    }

    public static OracleComplexSelect unionAll(Select ... selects) {
        return OracleComplexSelect.setOperation(new SetOperationInstanceCallBack(){

            public SetOperation instanceOperation() {
                return new UnionOperation(true);
            }
        }, selects);
    }

    public static OracleComplexSelect setOperation(SetOperationInstanceCallBack instance, Select ... selects) {
        OracleComplexSelect complexSelect = new OracleComplexSelect();
        ArrayList<PlainSelect> plainSelects = new ArrayList<PlainSelect>();
        ArrayList<SetOperation> operations = new ArrayList<SetOperation>();
        for (int i = 0; i < selects.length; ++i) {
            Select select = selects[0];
            plainSelects.add(select.getPlainSelect());
            if (i == 0) continue;
            operations.add(instance.instanceOperation());
        }
        complexSelect.operationList.setOpsAndSelects(plainSelects, operations);
        return complexSelect;
    }

    public static OracleComplexSelect minus(Select ... selects) {
        return OracleComplexSelect.setOperation(new SetOperationInstanceCallBack(){

            public SetOperation instanceOperation() {
                return new MinusOperation();
            }
        }, selects);
    }

    public static OracleComplexSelect intersect(Select ... selects) {
        return OracleComplexSelect.setOperation(new SetOperationInstanceCallBack(){

            public SetOperation instanceOperation() {
                return new IntersectOperation();
            }
        }, selects);
    }

    public OracleComplexSelect page(int start, int limit) {
        StringBuilder pagingSelect = new StringBuilder();
        if (start == 0) {
            start = 1;
        }
        pagingSelect.append("select * from ( select row_.*, rownum db_rownum from ( ");
        pagingSelect.append(this.sql());
        pagingSelect.append(" ) row_ where rownum <=" + (start + limit - 1) + ") where db_rownum >=" + start);
        this.stringBuilder = pagingSelect;
        return this;
    }
}

