/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.formitem;

import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.tinysqldsl.Select;
import org.tinygroup.tinysqldsl.base.Alias;
import org.tinygroup.tinysqldsl.base.SelectBody;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.expression.relational.ItemsList;
import org.tinygroup.tinysqldsl.formitem.FromItem;

public class SubSelect
implements FromItem,
Expression,
ItemsList {
    private SelectBody selectBody;
    private Alias alias;
    private boolean useBrackets = true;

    public SubSelect(SelectBody selectBody, Alias alias, boolean useBrackets) {
        this.selectBody = selectBody;
        this.alias = alias;
        this.useBrackets = useBrackets;
    }

    public static SubSelect subSelect(Select select) {
        return SubSelect.subSelect(select, "", true);
    }

    public static SubSelect subSelect(Select select, Alias alias, boolean useBrackets) {
        SubSelect subSelect = new SubSelect(select.getPlainSelect(), alias, useBrackets);
        return subSelect;
    }

    public static SubSelect subSelect(Select select, String aliasName, boolean useBrackets) {
        Alias alias = null;
        if (!StringUtil.isBlank((String)aliasName)) {
            alias = new Alias(aliasName);
        }
        return SubSelect.subSelect(select, alias, useBrackets);
    }

    public SelectBody getSelectBody() {
        return this.selectBody;
    }

    public void setSelectBody(SelectBody body) {
        this.selectBody = body;
    }

    public Alias getAlias() {
        return this.alias;
    }

    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    public boolean isUseBrackets() {
        return this.useBrackets;
    }

    public void setUseBrackets(boolean useBrackets) {
        this.useBrackets = useBrackets;
    }

    public String toString() {
        return (this.useBrackets ? "(" : "") + this.selectBody + (this.useBrackets ? ")" : "") + (this.alias != null ? this.alias.toString() : "");
    }

    public void builderItemList(StatementSqlBuilder builder) {
        this.internalBuilder(builder);
        Alias alias = this.getAlias();
        if (alias != null) {
            builder.appendSql(alias.toString());
        }
    }

    private void internalBuilder(StatementSqlBuilder builder) {
        StringBuilder buffer = builder.getStringBuilder();
        buffer.append(this.useBrackets ? "(" : "");
        this.getSelectBody().builderStatement(builder);
        buffer.append(this.useBrackets ? ")" : "");
    }

    public void builderFromItem(StatementSqlBuilder builder) {
        this.internalBuilder(builder);
        Alias alias = this.getAlias();
        if (alias != null) {
            builder.appendSql(alias.toString());
        }
    }

    public void builderExpression(StatementSqlBuilder builder) {
        this.internalBuilder(builder);
    }
}

