/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.insert;

import java.util.Iterator;
import java.util.List;
import org.tinygroup.tinysqldsl.base.Column;
import org.tinygroup.tinysqldsl.base.SelectBody;
import org.tinygroup.tinysqldsl.base.StatementBody;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.base.Table;
import org.tinygroup.tinysqldsl.expression.relational.ItemsList;
import org.tinygroup.tinysqldsl.selectitem.SelectExpressionItem;
import org.tinygroup.tinysqldsl.selectitem.SelectItem;
import org.tinygroup.tinysqldsl.util.DslUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertBody
implements StatementBody {
    private Table table;
    private List<Column> columns;
    private ItemsList itemsList;
    private boolean useValues = true;
    private SelectBody selectBody;
    private boolean useSelectBrackets = false;
    private boolean returningAllColumns = false;
    private List<SelectExpressionItem> returningExpressionList = null;

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setItemsList(ItemsList list) {
        this.itemsList = list;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    public boolean isReturningAllColumns() {
        return this.returningAllColumns;
    }

    public void setReturningAllColumns(boolean returningAllColumns) {
        this.returningAllColumns = returningAllColumns;
    }

    public List<SelectExpressionItem> getReturningExpressionList() {
        return this.returningExpressionList;
    }

    public void setReturningExpressionList(List<SelectExpressionItem> returningExpressionList) {
        this.returningExpressionList = returningExpressionList;
    }

    public SelectBody getSelectBody() {
        return this.selectBody;
    }

    public void setSelectBody(SelectBody selectBody) {
        this.selectBody = selectBody;
    }

    public boolean isUseSelectBrackets() {
        return this.useSelectBrackets;
    }

    public void setUseSelectBrackets(boolean useSelectBrackets) {
        this.useSelectBrackets = useSelectBrackets;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(this.table).append(" ");
        if (this.columns != null) {
            sql.append(DslUtil.getStringList(this.columns, true, true)).append(" ");
        }
        if (this.useValues) {
            sql.append(" VALUES");
        }
        if (this.itemsList != null) {
            sql.append(this.itemsList);
        }
        if (this.useSelectBrackets) {
            sql.append("(");
        }
        if (this.selectBody != null) {
            sql.append(this.selectBody);
        }
        if (this.useSelectBrackets) {
            sql.append(")");
        }
        if (this.isReturningAllColumns()) {
            sql.append(" RETURNING *");
        } else if (this.getReturningExpressionList() != null) {
            sql.append(" RETURNING ").append(DslUtil.getStringList(this.getReturningExpressionList(), true, false));
        }
        return sql.toString();
    }

    @Override
    public void builderStatement(StatementSqlBuilder builder) {
        Iterator<SelectItem> iter;
        StringBuilder buffer = builder.getStringBuilder();
        buffer.append("INSERT INTO ");
        buffer.append(this.getTable().getFullyQualifiedName());
        if (this.getColumns() != null) {
            buffer.append(" (");
            iter = this.getColumns().iterator();
            while (iter.hasNext()) {
                Column column = iter.next();
                buffer.append(column.getColumnName());
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(")");
        }
        if (this.useValues) {
            buffer.append(" VALUES");
        }
        if (this.getItemsList() != null) {
            this.getItemsList().builderItemList(builder);
        }
        if (this.getSelectBody() != null) {
            buffer.append(" ");
            if (this.isUseSelectBrackets()) {
                buffer.append("(");
            }
            this.getSelectBody().builderStatement(builder);
            if (this.isUseSelectBrackets()) {
                buffer.append(")");
            }
        }
        if (this.isReturningAllColumns()) {
            buffer.append(" RETURNING *");
        } else if (this.getReturningExpressionList() != null) {
            buffer.append(" RETURNING ");
            iter = this.getReturningExpressionList().iterator();
            while (iter.hasNext()) {
                buffer.append(((SelectExpressionItem)iter.next()).toString());
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
        }
    }
}

