/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.operator;

import org.tinygroup.tinysqldsl.base.Condition;
import org.tinygroup.tinysqldsl.expression.BinaryExpression;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.expression.JdbcParameter;
import org.tinygroup.tinysqldsl.expression.relational.Between;
import org.tinygroup.tinysqldsl.expression.relational.EqualsTo;
import org.tinygroup.tinysqldsl.expression.relational.ExpressionList;
import org.tinygroup.tinysqldsl.expression.relational.GreaterThan;
import org.tinygroup.tinysqldsl.expression.relational.GreaterThanEquals;
import org.tinygroup.tinysqldsl.expression.relational.InExpression;
import org.tinygroup.tinysqldsl.expression.relational.IsEmptyExpression;
import org.tinygroup.tinysqldsl.expression.relational.IsNullExpression;
import org.tinygroup.tinysqldsl.expression.relational.ItemsList;
import org.tinygroup.tinysqldsl.expression.relational.LikeExpression;
import org.tinygroup.tinysqldsl.expression.relational.MinorThan;
import org.tinygroup.tinysqldsl.expression.relational.MinorThanEquals;
import org.tinygroup.tinysqldsl.expression.relational.NotEqualsTo;
import org.tinygroup.tinysqldsl.operator.BinaryOperator;
import org.tinygroup.tinysqldsl.operator.ExpressionInstanceCallBack;
import org.tinygroup.tinysqldsl.transform.ExpressionTransform;
import org.tinygroup.tinysqldsl.transform.JdbcParameterExpressionTransform;

public abstract class SimpleBinaryOperator
implements BinaryOperator,
Expression,
ExpressionTransform {
    private ExpressionTransform transform = new JdbcParameterExpressionTransform();

    public ExpressionTransform getTransform() {
        return this.transform;
    }

    public void setTransform(ExpressionTransform transform) {
        this.transform = transform;
    }

    public Condition eq(Object value) {
        return this.equal(value);
    }

    public Condition equal(Object value) {
        return this.toCondition(value, new ExpressionInstanceCallBack(){

            public BinaryExpression instance(Expression leExpression, Expression rightExpression) {
                return new EqualsTo(leExpression, rightExpression);
            }

            public Object format(Object value) {
                return value;
            }
        });
    }

    public Condition toCondition(Object value, ExpressionInstanceCallBack callBack) {
        if (value == null || value.toString().trim().equals("")) {
            return null;
        }
        Object newValue = callBack.format(value);
        Expression rightExpression = this.transform(newValue);
        BinaryExpression expression = callBack.instance(this, rightExpression);
        Condition condition = null;
        condition = this.isParameterExpression(rightExpression) ? new Condition(expression, newValue) : new Condition(expression, new Object[0]);
        return condition;
    }

    public Condition neq(Object value) {
        return this.notEqual(value);
    }

    public Condition notEqual(Object value) {
        return this.toCondition(value, new ExpressionInstanceCallBack(){

            public BinaryExpression instance(Expression leExpression, Expression rightExpression) {
                return new NotEqualsTo(leExpression, rightExpression);
            }

            public Object format(Object value) {
                return value;
            }
        });
    }

    public Condition gt(Object value) {
        return this.greaterThan(value);
    }

    public Condition greaterThan(Object value) {
        return this.toCondition(value, new ExpressionInstanceCallBack(){

            public BinaryExpression instance(Expression leExpression, Expression rightExpression) {
                return new GreaterThan(leExpression, rightExpression);
            }

            public Object format(Object value) {
                return value;
            }
        });
    }

    public Condition gte(Object value) {
        return this.greaterThanEqual(value);
    }

    public Condition greaterThanEqual(Object value) {
        return this.toCondition(value, new ExpressionInstanceCallBack(){

            public BinaryExpression instance(Expression leExpression, Expression rightExpression) {
                return new GreaterThanEquals(leExpression, rightExpression);
            }

            public Object format(Object value) {
                return value;
            }
        });
    }

    public Condition lt(Object value) {
        return this.lessThan(value);
    }

    public Condition lessThan(Object value) {
        return this.toCondition(value, new ExpressionInstanceCallBack(){

            public BinaryExpression instance(Expression leExpression, Expression rightExpression) {
                return new MinorThan(leExpression, rightExpression);
            }

            public Object format(Object value) {
                return value;
            }
        });
    }

    public Condition lte(Object value) {
        return this.lessThanEqual(value);
    }

    public Condition lessThanEqual(Object value) {
        return this.toCondition(value, new ExpressionInstanceCallBack(){

            public BinaryExpression instance(Expression leExpression, Expression rightExpression) {
                return new MinorThanEquals(leExpression, rightExpression);
            }

            public Object format(Object value) {
                return value;
            }
        });
    }

    public Condition isNull() {
        IsNullExpression isNull = new IsNullExpression(this);
        Condition condition = new Condition(isNull, new Object[0]);
        return condition;
    }

    public Condition isNotNull() {
        IsNullExpression isNotNull = new IsNullExpression(this, true);
        Condition condition = new Condition(isNotNull, new Object[0]);
        return condition;
    }

    public Condition isEmpty() {
        IsEmptyExpression isEmpty = new IsEmptyExpression(this);
        return new Condition(isEmpty, new Object[0]);
    }

    public Condition isNotEmpty() {
        IsEmptyExpression isEmpty = new IsEmptyExpression(this, true);
        return new Condition(isEmpty, new Object[0]);
    }

    public Condition like(String value) {
        return this.toCondition(value, new ExpressionInstanceCallBack(){

            public BinaryExpression instance(Expression leExpression, Expression rightExpression) {
                return new LikeExpression(leExpression, rightExpression);
            }

            public Object format(Object value) {
                return "%" + value + "%";
            }
        });
    }

    public Condition notLike(String value) {
        return this.toCondition(value, new ExpressionInstanceCallBack(){

            public BinaryExpression instance(Expression leExpression, Expression rightExpression) {
                return new LikeExpression(leExpression, rightExpression, true);
            }

            public Object format(Object value) {
                return "%" + value + "%";
            }
        });
    }

    public Condition notLeftLike(String value) {
        return this.toCondition(value, new ExpressionInstanceCallBack(){

            public BinaryExpression instance(Expression leExpression, Expression rightExpression) {
                return new LikeExpression(leExpression, rightExpression, true);
            }

            public Object format(Object value) {
                return value + "%";
            }
        });
    }

    public Condition notRightLike(String value) {
        return this.toCondition(value, new ExpressionInstanceCallBack(){

            public BinaryExpression instance(Expression leExpression, Expression rightExpression) {
                return new LikeExpression(leExpression, rightExpression, true);
            }

            public Object format(Object value) {
                return "%" + value;
            }
        });
    }

    public Condition leftLike(String value) {
        return this.toCondition(value, new ExpressionInstanceCallBack(){

            public BinaryExpression instance(Expression leExpression, Expression rightExpression) {
                return new LikeExpression(leExpression, rightExpression);
            }

            public Object format(Object value) {
                return value + "%";
            }
        });
    }

    public Condition rightLike(String value) {
        return this.toCondition(value, new ExpressionInstanceCallBack(){

            public BinaryExpression instance(Expression leExpression, Expression rightExpression) {
                return new LikeExpression(leExpression, rightExpression);
            }

            public Object format(Object value) {
                return "%" + value;
            }
        });
    }

    public Condition between(Object begin, Object end) {
        Between between = new Between(this, new JdbcParameter(), new JdbcParameter());
        return new Condition(between, begin, end);
    }

    public Condition notBetween(Object begin, Object end) {
        Between between = new Between(this, new JdbcParameter(), new JdbcParameter(), true);
        return new Condition(between, begin, end);
    }

    public Condition in(Object ... values) {
        ExpressionList rightItemsList = new ExpressionList();
        for (int i = 0; i < values.length; ++i) {
            rightItemsList.addExpression(new JdbcParameter());
        }
        InExpression inExpression = new InExpression(this, (ItemsList)rightItemsList);
        return new Condition(inExpression, values);
    }

    public Condition notIn(Object ... values) {
        ExpressionList rightItemsList = new ExpressionList();
        for (int i = 0; i < values.length; ++i) {
            rightItemsList.addExpression(new JdbcParameter());
        }
        InExpression inExpression = new InExpression(this, (ItemsList)rightItemsList, true);
        return new Condition(inExpression, values);
    }

    public Expression transform(Object value) {
        return this.transform.transform(value);
    }

    public boolean isParameterExpression(Expression expression) {
        return this.transform.isParameterExpression(expression);
    }
}

