/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tinygroup.tinysqldsl.base.SelectBody;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.select.Fetch;
import org.tinygroup.tinysqldsl.select.Limit;
import org.tinygroup.tinysqldsl.select.Offset;
import org.tinygroup.tinysqldsl.select.OrderByElement;
import org.tinygroup.tinysqldsl.select.PlainSelect;
import org.tinygroup.tinysqldsl.select.SetOperation;
import org.tinygroup.tinysqldsl.util.DslUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetOperationList
implements SelectBody {
    private List<PlainSelect> plainSelects;
    private List<SetOperation> operations;
    private List<OrderByElement> orderByElements;
    private Limit limit;
    private Offset offset;
    private Fetch fetch;

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public List<PlainSelect> getPlainSelects() {
        return this.plainSelects;
    }

    public List<SetOperation> getOperations() {
        return this.operations;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public void setOpsAndSelects(List<PlainSelect> select, List<SetOperation> ops) {
        this.plainSelects = select;
        this.operations = ops;
        if (select.size() - 1 != ops.size()) {
            throw new IllegalArgumentException("list sizes are not valid");
        }
    }

    public void addOrderByElements(OrderByElement ... orderBys) {
        if (this.orderByElements == null) {
            this.orderByElements = new ArrayList<OrderByElement>();
        }
        Collections.addAll(this.orderByElements, orderBys);
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.plainSelects.size(); ++i) {
            if (i != 0) {
                buffer.append(" ").append(this.operations.get(i - 1).toString()).append(" ");
            }
            buffer.append("(").append(this.plainSelects.get(i).toString()).append(")");
        }
        if (this.orderByElements != null) {
            buffer.append(DslUtil.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            buffer.append(this.limit.toString());
        }
        if (this.offset != null) {
            buffer.append(this.offset.toString());
        }
        if (this.fetch != null) {
            buffer.append(this.fetch.toString());
        }
        return buffer.toString();
    }

    @Override
    public void builderStatement(StatementSqlBuilder builder) {
        StringBuilder buffer = builder.getStringBuilder();
        for (int i = 0; i < this.getPlainSelects().size(); ++i) {
            if (i != 0) {
                buffer.append(' ').append(this.getOperations().get(i - 1)).append(' ');
            }
            buffer.append("(");
            PlainSelect plainSelect = this.getPlainSelects().get(i);
            plainSelect.builderStatement(builder);
            buffer.append(")");
        }
        if (this.getOrderByElements() != null) {
            builder.deparseOrderBy(this.getOrderByElements());
        }
        if (this.getLimit() != null) {
            builder.deparseLimit(this.getLimit());
        }
        if (this.getOffset() != null) {
            builder.deparseOffset(this.getOffset());
        }
        if (this.getFetch() != null) {
            builder.deparseFetch(this.getFetch());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SetOperationType {
        INTERSECT,
        EXCEPT,
        MINUS,
        UNION;

    }
}

