/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.update;

import java.util.List;
import org.tinygroup.tinysqldsl.base.Column;
import org.tinygroup.tinysqldsl.base.SelectBody;
import org.tinygroup.tinysqldsl.base.StatementBody;
import org.tinygroup.tinysqldsl.base.StatementSqlBuilder;
import org.tinygroup.tinysqldsl.base.Table;
import org.tinygroup.tinysqldsl.expression.Expression;
import org.tinygroup.tinysqldsl.formitem.FromItem;
import org.tinygroup.tinysqldsl.select.Join;
import org.tinygroup.tinysqldsl.util.DslUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateBody
implements StatementBody {
    private List<Table> tables;
    private Expression where;
    private List<Column> columns;
    private List<Expression> expressions;
    private FromItem fromItem;
    private List<Join> joins;
    private SelectBody selectBody;
    private boolean useColumnsBrackets = true;
    private boolean useSelect = false;

    public List<Table> getTables() {
        return this.tables;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setTables(List<Table> list) {
        this.tables = list;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    public SelectBody getSelectBody() {
        return this.selectBody;
    }

    public void setSelectBody(SelectBody selectBody) {
        this.selectBody = selectBody;
    }

    public boolean isUseColumnsBrackets() {
        return this.useColumnsBrackets;
    }

    public void setUseColumnsBrackets(boolean useColumnsBrackets) {
        this.useColumnsBrackets = useColumnsBrackets;
    }

    public boolean isUseSelect() {
        return this.useSelect;
    }

    public void setUseSelect(boolean useSelect) {
        this.useSelect = useSelect;
    }

    public String toString() {
        int i;
        StringBuilder b = new StringBuilder("UPDATE ");
        b.append(DslUtil.getStringList(this.getTables(), true, false)).append(" SET ");
        if (!this.useSelect) {
            for (i = 0; i < this.getColumns().size(); ++i) {
                if (i != 0) {
                    b.append(", ");
                }
                b.append(this.columns.get(i)).append(" = ");
                b.append(this.expressions.get(i));
            }
        } else {
            if (this.useColumnsBrackets) {
                b.append("(");
            }
            for (i = 0; i < this.getColumns().size(); ++i) {
                if (i != 0) {
                    b.append(", ");
                }
                b.append(this.columns.get(i));
            }
            if (this.useColumnsBrackets) {
                b.append(")");
            }
            b.append(" = ");
            b.append("(").append(this.selectBody).append(")");
        }
        if (this.fromItem != null) {
            b.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        b.append(", ").append(join);
                        continue;
                    }
                    b.append(" ").append(join);
                }
            }
        }
        if (this.where != null) {
            b.append(" WHERE ");
            b.append(this.where);
        }
        return b.toString();
    }

    @Override
    public void builderStatement(StatementSqlBuilder builder) {
        Column column;
        StringBuilder buffer = builder.getStringBuilder();
        buffer.append("UPDATE ").append(DslUtil.getStringList(this.getTables(), true, false)).append(" SET ");
        if (!this.isUseSelect()) {
            for (int i = 0; i < this.getColumns().size(); ++i) {
                column = this.getColumns().get(i);
                buffer.append(column.getFullyQualifiedName()).append(" = ");
                Expression expression = this.getExpressions().get(i);
                expression.builderExpression(builder);
                if (i >= this.getColumns().size() - 1) continue;
                buffer.append(", ");
            }
        } else {
            if (this.isUseColumnsBrackets()) {
                buffer.append("(");
            }
            for (int i = 0; i < this.getColumns().size(); ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                column = this.getColumns().get(i);
                buffer.append(column.getFullyQualifiedName());
            }
            if (this.isUseColumnsBrackets()) {
                buffer.append(")");
            }
            buffer.append(" = ");
            buffer.append("(");
            SelectBody selectBody = this.getSelectBody();
            selectBody.builderStatement(builder);
            buffer.append(")");
        }
        if (this.getFromItem() != null) {
            buffer.append(" FROM ").append(this.getFromItem());
            if (this.getJoins() != null) {
                for (Join join : this.getJoins()) {
                    if (join.isSimple()) {
                        buffer.append(", ").append(join);
                        continue;
                    }
                    buffer.append(" ").append(join);
                }
            }
        }
        if (this.getWhere() != null) {
            buffer.append(" WHERE ");
            this.getWhere().builderExpression(builder);
        }
    }
}

