/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinysqldsl.util;

import java.util.List;
import org.tinygroup.tinysqldsl.select.OrderByElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DslUtil {
    public static String orderByToString(List<OrderByElement> orderByElements) {
        return DslUtil.orderByToString(false, orderByElements);
    }

    public static String orderByToString(boolean oracleSiblings, List<OrderByElement> orderByElements) {
        return DslUtil.getFormattedList(orderByElements, oracleSiblings ? "ORDER SIBLINGS BY" : "ORDER BY");
    }

    public static String getFormattedList(List<?> list, String expression) {
        return DslUtil.getFormattedList(list, expression, true, false);
    }

    public static String getFormattedList(List<?> list, String expression, boolean useComma, boolean useBrackets) {
        String sql = DslUtil.getStringList(list, useComma, useBrackets);
        if (sql.length() > 0) {
            sql = expression.length() > 0 ? " " + expression + " " + sql : " " + sql;
        }
        return sql;
    }

    public static String getStringList(List<?> list) {
        return DslUtil.getStringList(list, true, false);
    }

    public static String getStringList(List<?> list, boolean useComma, boolean useBrackets, String comma) {
        StringBuffer buffer = new StringBuffer();
        if (!useComma) {
            comma = "";
        }
        if (list != null) {
            if (useBrackets) {
                buffer.append("(");
            }
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(list.get(i)).append(i < list.size() - 1 ? comma : "");
            }
            if (useBrackets) {
                buffer.append(")");
            }
        }
        return buffer.toString();
    }

    public static String getStringList(List<?> list, boolean useComma, boolean useBrackets) {
        return DslUtil.getStringList(list, useComma, useBrackets, ",");
    }
}

