/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.umlg.java.metamodel.OJBlock;
import org.umlg.java.metamodel.OJConstructor;
import org.umlg.java.metamodel.OJField;
import org.umlg.java.metamodel.OJPackage;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.OJVisibilityKind;
import org.umlg.java.metamodel.generated.OJClassGEN;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;
import org.umlg.java.metamodel.utilities.JavaUtil;

public class OJClass
extends OJClassGEN {
    public OJClass() {
        this.setVisibility(OJVisibilityKind.PUBLIC);
    }

    public OJClass(String name, String comment, boolean isStatic, boolean isFinal, boolean isVolatile, int uniqueNumber, boolean isAbstract, boolean isDerived) {
    }

    public OJClass getDeepCopy(OJPackage owner) {
        OJClass copy = new OJClass();
        copy.setMyPackage(owner);
        this.copyDeepInfoInto(copy);
        return copy;
    }

    protected void copyDeepInfoInto(OJClass copy) {
        super.copyDeepInfoInto(copy);
        Set<OJConstructor> constructors = this.getConstructors();
        for (OJConstructor ojConstructor : constructors) {
            OJConstructor copyConstructor = ojConstructor.getDeepConstructorCopy();
            copyConstructor.setReturnType(copy.getPathName());
            copy.addToConstructors(copyConstructor);
        }
        if (this.getSuperclass() != null) {
            OJPathName superClassCopy = this.getSuperclass().getDeepCopy();
            copy.setSuperclass(superClassCopy);
        }
        Collection<OJField> fields = this.getFields();
        for (OJField ojField : fields) {
            OJField ojFieldCopy = ojField.getDeepCopy();
            ojFieldCopy.setOwner(copy);
            copy.addToFields(ojFieldCopy);
        }
    }

    @Override
    public void calcImports() {
        super.calcImports();
        for (OJField f : this.getFields()) {
            this.addToImports(f.getType());
        }
        for (OJPathName intf : this.getImplementedInterfaces()) {
            this.addToImports(intf);
        }
        for (OJConstructor constr : this.getConstructors()) {
            Iterator<OJPathName> params = constr.getParamTypes().iterator();
            while (params.hasNext()) {
                this.addToImports(params.next());
            }
        }
        this.addToImports(this.getSuperclass());
    }

    @Override
    public OJConstructor getDefaultConstructor() {
        OJConstructor result = super.getDefaultConstructor();
        if (result == null) {
            OJConstructor constructor = new OJConstructor();
            constructor.setBody(new OJBlock());
            constructor.setComment("default constructor for " + this.getName());
            this.addToConstructors(constructor);
            result = constructor;
        }
        return result;
    }

    @Override
    public String toJavaString() {
        this.calcImports();
        StringBuilder classInfo = new StringBuilder();
        classInfo.append(this.getMyPackage().toJavaString());
        classInfo.append("\n");
        classInfo.append((CharSequence)this.imports());
        classInfo.append("\n");
        if (!this.getComment().equals("")) {
            this.addJavaDocComment(classInfo);
        }
        if (this.getNeedsSuppress()) {
            classInfo.append("@SuppressWarnings(\"serial\")\n");
        }
        if (this.isAbstract()) {
            classInfo.append("abstract ");
        }
        classInfo.append(this.visToJava(this) + " ");
        classInfo.append("class " + this.getName());
        if (this.getSuperclass() != null) {
            classInfo.append(" extends " + this.getSuperclass().getLast());
        }
        classInfo.append((CharSequence)this.implementedInterfaces());
        classInfo.append(" {\n");
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.fields(), 1));
        classInfo.append("\n\n");
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.constructors(), 1));
        classInfo.append("\n");
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.operations(), 1));
        classInfo.append("\n}");
        return classInfo.toString();
    }

    private StringBuilder constructors() {
        StringBuilder result = new StringBuilder();
        result.append(JavaUtil.collectionToJavaString(this.getConstructors(), "\n"));
        return result;
    }

    private StringBuilder fields() {
        StringBuilder result = new StringBuilder();
        result.append(JavaUtil.collectionToJavaString(this.getFields(), "\n"));
        return result;
    }

    private StringBuilder implementedInterfaces() {
        StringBuilder result = new StringBuilder();
        if (!this.getImplementedInterfaces().isEmpty()) {
            result.append(" implements ");
        }
        Iterator<OJPathName> it = this.getImplementedInterfaces().iterator();
        while (it.hasNext()) {
            OJPathName elem = it.next();
            result.append(elem.getLast());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result;
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String suffix) {
        super.renameAll(renamePathNames, suffix);
        Set<OJConstructor> constructors = this.getConstructors();
        for (OJConstructor ojConstructor : constructors) {
            ojConstructor.renameAll(renamePathNames, suffix);
        }
        HashSet<OJPathName> newImports = new HashSet<OJPathName>();
        Set<OJPathName> imports = this.getImports();
        for (OJPathName oJPathName : imports) {
            OJPathName newImport = oJPathName.getDeepCopy();
            newImport.renameAll(renamePathNames, suffix);
            newImports.add(newImport);
        }
        this.addToImports(newImports);
        if (this.getSuperclass() != null) {
            this.getSuperclass().renameAll(renamePathNames, suffix);
        }
        Set<OJPathName> implementedInterfaces = this.getImplementedInterfaces();
        for (OJPathName ojPathName : implementedInterfaces) {
            ojPathName.renameAll(renamePathNames, suffix);
        }
        Collection<OJField> collection = this.getFields();
        for (OJField ojField : collection) {
            ojField.renameAll(renamePathNames, suffix);
        }
    }

    public void release() {
        this.setMyPackage(null);
        this.f_fields.clear();
        this.f_operations.clear();
        super.removeAllFromConstructors();
        super.removeAllFromImports();
    }
}

