/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel;

import org.umlg.java.metamodel.OJClassifier;
import org.umlg.java.metamodel.generated.OJConstructorGEN;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;
import org.umlg.java.metamodel.utilities.JavaUtil;

public class OJConstructor
extends OJConstructorGEN {
    @Override
    public OJClassifier getOwner() {
        return this.getOwningClass();
    }

    @Override
    public OJConstructor getDeepCopy() {
        OJConstructor result = new OJConstructor();
        this.copyValuesDeep(result);
        return result;
    }

    @Override
    public String toJavaString() {
        StringBuilder result = new StringBuilder();
        if (this.getComment().equals("")) {
            this.setComment("constructor for " + this.getOwner().getName());
        }
        this.addJavaDocComment(result);
        result.append(this.visToJava(this) + " " + this.getOwner().getName());
        result.append("(" + this.paramsToJava(this) + ") ");
        if (!this.getThrows().isEmpty()) {
            result.append("throws " + this.exceptionsToJava(this) + " {\n");
        } else {
            result.append(" {\n");
        }
        StringBuilder bodyStr = new StringBuilder();
        bodyStr.append(JavaUtil.collectionToJavaString(this.getBody().getStatements(), "\n"));
        result.append((CharSequence)JavaStringHelpers.indent(bodyStr, 1));
        if (result.charAt(result.length() - 1) == '\n') {
            result.deleteCharAt(result.length() - 1);
        }
        result.append("\n}\n");
        return result.toString();
    }

    public OJConstructor getConstructorCopy() {
        OJConstructor result = new OJConstructor();
        super.copyValues(result);
        return result;
    }

    public OJConstructor getDeepConstructorCopy() {
        OJConstructor result = new OJConstructor();
        super.copyValuesDeep(result);
        return result;
    }
}

