/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel;

import java.util.Set;
import org.umlg.java.metamodel.OJBlock;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.OJVisibilityKind;
import org.umlg.java.metamodel.annotation.OJAnnotatedClass;
import org.umlg.java.metamodel.generated.OJFieldGEN;

public class OJField
extends OJFieldGEN {
    public OJField() {
        this.setVisibility(OJVisibilityKind.PRIVATE);
    }

    public OJField(OJAnnotatedClass clazz, String name, OJPathName type) {
        this(name, type);
        clazz.addToFields(this);
    }

    public OJField(OJBlock block, String name, OJPathName type) {
        this(name, type);
        block.addToLocals(this);
    }

    public OJField(OJBlock body, String name, String path) {
        this(body, name, new OJPathName(path));
    }

    public OJField(String name, OJPathName type) {
        this.setName(name);
        this.setType(type);
    }

    public OJField(OJBlock body, String name, OJPathName type, String initExpr) {
        this(body, name, type);
        this.setInitExp(initExpr);
    }

    public OJField(String name, String path) {
        this(name, new OJPathName(path));
    }

    @Override
    public String toJavaString() {
        String result = "";
        if (this.getOwner() != null) {
            result = result + this.visToJava(this);
        }
        if (result.length() > 0) {
            result = result + " ";
        }
        result = result + this.getType().getCollectionTypeName();
        result = result + " " + this.getName();
        if (this.getInitExp() != null && !this.getInitExp().equals("")) {
            result = result + " = " + this.getInitExp();
        }
        result = result + ";";
        if (!this.getComment().equals("")) {
            result = result + "\t// " + this.getComment();
        }
        return result;
    }

    public OJField getDeepCopy() {
        OJField copy = new OJField();
        this.copyDeepInfoInto(copy);
        return copy;
    }

    @Override
    public void copyDeepInfoInto(OJField copy) {
        super.copyDeepInfoInto(copy);
        copy.setInitExp(this.getInitExp());
        if (this.getType() != null) {
            copy.setType(this.getType().getDeepCopy());
        }
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String suffix) {
        this.getType().renameAll(renamePathNames, suffix);
        String init = this.getInitExp();
        this.setInitExp(OJField.replaceAll(init, renamePathNames, suffix));
    }
}

